const core = require('@sentry/core');
const scope = require('../../common/scope.js');
const ipc = require('../ipc.js');

/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = core.defineIntegration(() => {
    return {
        name: 'ScopeToMain',
        setup() {
            const ipc$1 = ipc.getIPC();
            scope.addScopeListener((merged, changed) => {
                ipc$1.sendScope(JSON.stringify(core.normalize(merged, 20, 2000)));
                changed.clearBreadcrumbs();
                changed.clearAttachments();
            });
        },
    };
});

exports.scopeToMainIntegration = scopeToMainIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/3fa438a81d579067162dd8767025b788454e6f90/node_modules/@sentry/electron/renderer/integrations/scope-to-main.js.map
