import { Observable, operate } from '../Observable.js';
export function pairwise() {
    return (source) => new Observable((destination) => {
        let prev;
        let hasPrev = false;
        source.subscribe(operate({
            destination,
            next: (value) => {
                const p = prev;
                prev = value;
                hasPrev && destination.next([p, value]);
                hasPrev = true;
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/3d2e45538bcc4fd7ed28cc113c2110b26a824a00/node_modules/rxjs/dist/esm/internal/operators/pairwise.js.map