"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.merge = void 0;
const Observable_js_1 = require("../Observable.js");
const mergeAll_js_1 = require("../operators/mergeAll.js");
const empty_js_1 = require("./empty.js");
const args_js_1 = require("../util/args.js");
const scheduled_js_1 = require("../scheduled/scheduled.js");
function merge(...args) {
    const scheduler = (0, args_js_1.popScheduler)(args);
    const concurrent = (0, args_js_1.popNumber)(args, Infinity);
    const sources = args;
    return !sources.length
        ?
            empty_js_1.EMPTY
        : sources.length === 1
            ?
                (0, Observable_js_1.from)(sources[0])
            :
                (0, mergeAll_js_1.mergeAll)(concurrent)(scheduler ? (0, scheduled_js_1.scheduled)(sources, scheduler) : (0, Observable_js_1.from)(sources));
}
exports.merge = merge;//# sourceMappingURL=http://go/sourcemap/sourcemaps/3d2e45538bcc4fd7ed28cc113c2110b26a824a00/node_modules/rxjs/dist/cjs/internal/observable/merge.js.map