const core = require('@sentry/core');
const node = require('@sentry/node');
const transport = require('./transport.js');

const defaultStackParser = core.createStackParser(core.nodeStackLineParser(node.createGetModuleFromFilename()));
/** Get the default integrations for the main process SDK. */
function getDefaultIntegrations() {
    const integrations = [
        // Node integrations
        node.eventFiltersIntegration(),
        node.functionToStringIntegration(),
        node.linkedErrorsIntegration(),
        node.consoleIntegration(),
        node.nativeNodeFetchIntegration(),
        node.onUncaughtExceptionIntegration(),
        node.onUnhandledRejectionIntegration(),
    ];
    return integrations;
}
/**
 * Initialize Sentry in the Electron main process
 */
function init(userOptions = {}) {
    const optionsWithDefaults = {
        defaultIntegrations: getDefaultIntegrations(),
        transport: transport.makeUtilityProcessTransport(),
        sendClientReports: false,
        ...userOptions,
        stackParser: core.stackParserFromStackParserOptions(userOptions.stackParser || defaultStackParser),
        // Events are sent via the main process but the Node SDK wont start without dsn
        dsn: 'https://12345@dummy.dsn/12345',
        includeServerName: false,
    };
    const options = {
        ...optionsWithDefaults,
        integrations: core.getIntegrationsToSetup(optionsWithDefaults),
    };
    if (options.debug) {
        core.debug.enable();
    }
    node.setNodeAsyncContextStrategy();
    const scope = node.getCurrentScope();
    scope.update(options.initialScope);
    const client = new node.NodeClient(options);
    scope.setClient(client);
    client.init();
    // If users opt-out of this, they _have_ to set up OpenTelemetry themselves
    // There is no way to use this SDK without OpenTelemetry!
    if (!options.skipOpenTelemetrySetup) {
        node.initOpenTelemetry(client);
    }
}

exports.defaultStackParser = defaultStackParser;
exports.getDefaultIntegrations = getDefaultIntegrations;
exports.init = init;//# sourceMappingURL=http://go/sourcemap/sourcemaps/3af786aea415e7592d1aa8eccad88e5fed508620/node_modules/@sentry/electron/utility/sdk.js.map
