const core = require('@sentry/core');

/** Gets the merged scope data */
function getScopeData() {
    const globalScope = core.getGlobalScope().getScopeData();
    const isolationScope = core.getIsolationScope().getScopeData();
    const currentScope = core.getCurrentScope().getScopeData();
    core.mergeScopeData(globalScope, isolationScope);
    core.mergeScopeData(globalScope, currentScope);
    globalScope.eventProcessors = [];
    return globalScope;
}
/** Hooks both current and isolation scope changes and passes merged scope on changes  */
function addScopeListener(callback) {
    core.getIsolationScope().addScopeListener((isolation) => {
        const merged = getScopeData();
        callback(merged, isolation);
    });
    core.getCurrentScope().addScopeListener((current) => {
        const merged = getScopeData();
        callback(merged, current);
    });
    core.getGlobalScope().addScopeListener((global) => {
        const merged = getScopeData();
        callback(merged, global);
    });
}

exports.addScopeListener = addScopeListener;
exports.getScopeData = getScopeData;//# sourceMappingURL=http://go/sourcemap/sourcemaps/3af786aea415e7592d1aa8eccad88e5fed508620/node_modules/@sentry/electron/common/scope.js.map
