Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const attributes = require('./attributes.js');

/**
 * PII attributes that should be removed when sendDefaultPii is false
 * @internal
 */
const PII_ATTRIBUTES = new Set([
  attributes.CLIENT_ADDRESS_ATTRIBUTE,
  attributes.CLIENT_PORT_ATTRIBUTE,
  attributes.MCP_LOGGING_MESSAGE_ATTRIBUTE,
  attributes.MCP_RESOURCE_URI_ATTRIBUTE,
  attributes.MCP_TOOL_RESULT_CONTENT_ATTRIBUTE,
]);

/**
 * Checks if an attribute key should be considered PII
 * @internal
 */
function isPiiAttribute(key) {
  return PII_ATTRIBUTES.has(key) || key.startsWith(`${attributes.MCP_REQUEST_ARGUMENT}.`);
}

/**
 * Removes PII attributes from span data when sendDefaultPii is false
 * @param spanData - Raw span attributes
 * @param sendDefaultPii - Whether to include PII data
 * @returns Filtered span attributes
 */
function filterMcpPiiFromSpanData(
  spanData,
  sendDefaultPii,
) {
  if (sendDefaultPii) {
    return spanData ;
  }

  return Object.entries(spanData).reduce(
    (acc, [key, value]) => {
      if (!isPiiAttribute(key)) {
        acc[key] = value ;
      }
      return acc;
    },
    {} ,
  );
}

exports.filterMcpPiiFromSpanData = filterMcpPiiFromSpanData;//# sourceMappingURL=http://go/sourcemap/sourcemaps/3abd9532939196eeaddaedfab2cf0b286a702cf0/node_modules/@sentry/core/build/cjs/integrations/mcp-server/piiFiltering.js.map
