import { identity } from '../util/identity.js';
import { Observable, operate } from '../Observable.js';
export function distinctUntilChanged(comparator, keySelector = identity) {
    comparator = comparator ?? defaultCompare;
    return (source) => new Observable((destination) => {
        let previousKey;
        let first = true;
        source.subscribe(operate({
            destination,
            next: (value) => {
                const currentKey = keySelector(value);
                if (first || !comparator(previousKey, currentKey)) {
                    first = false;
                    previousKey = currentKey;
                    destination.next(value);
                }
            },
        }));
    });
}
function defaultCompare(a, b) {
    return a === b;
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/39a966b4048ef6b8024b27d4812a50d88de29cc0/node_modules/rxjs/dist/esm/internal/operators/distinctUntilChanged.js.map