"use client";

// src/useIsFetching.ts
import * as React from "react";
import { notifyManager } from "@tanstack/query-core";
import { useQueryClient } from "./QueryClientProvider.js";
function useIsFetching(filters, queryClient) {
  const client = useQueryClient(queryClient);
  const queryCache = client.getQueryCache();
  return React.useSyncExternalStore(
    React.useCallback(
      (onStoreChange) => queryCache.subscribe(notifyManager.batchCalls(onStoreChange)),
      [queryCache]
    ),
    () => client.isFetching(filters),
    () => client.isFetching(filters)
  );
}
export {
  useIsFetching
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/39a966b4048ef6b8024b27d4812a50d88de29cc0/node_modules/@tanstack/react-query/build/modern/useIsFetching.js.map