import { DEBUG_BUILD } from './debug-build.js';
import { debug } from './utils/debug-logger.js';
import { isThenable } from './utils/is.js';
import { resolvedSyncPromise, rejectedSyncPromise } from './utils/syncpromise.js';

/**
 * Process an array of event processors, returning the processed event (or `null` if the event was dropped).
 */
function notifyEventProcessors(
  processors,
  event,
  hint,
  index = 0,
) {
  try {
    const result = _notifyEventProcessors(event, hint, processors, index);
    return isThenable(result) ? result : resolvedSyncPromise(result);
  } catch (error) {
    return rejectedSyncPromise(error);
  }
}

function _notifyEventProcessors(
  event,
  hint,
  processors,
  index,
) {
  const processor = processors[index];

  if (!event || !processor) {
    return event;
  }

  const result = processor({ ...event }, hint);

  DEBUG_BUILD && result === null && debug.log(`Event processor "${processor.id || '?'}" dropped event`);

  if (isThenable(result)) {
    return result.then(final => _notifyEventProcessors(final, hint, processors, index + 1));
  }

  return _notifyEventProcessors(result, hint, processors, index + 1);
}

export { notifyEventProcessors };//# sourceMappingURL=http://go/sourcemap/sourcemaps/39a966b4048ef6b8024b27d4812a50d88de29cc0/node_modules/@sentry/core/build/esm/eventProcessors.js.map
