const browser = require('@sentry/browser');
const core = require('@sentry/core');
const scopeToMain = require('./integrations/scope-to-main.js');
const stackParse = require('./stack-parse.js');
const transport = require('./transport.js');

/* eslint-disable deprecation/deprecation */
/* eslint-disable no-restricted-globals */
/** Get the default integrations for the renderer SDK. */
function getDefaultIntegrations(options) {
    return [
        ...browser.getDefaultIntegrations(options).filter((i) => i.name !== 'BrowserSession'),
        scopeToMain.scopeToMainIntegration(),
    ];
}
/**
 * Initialize Sentry in the Electron renderer process
 * @param options SDK options
 * @param originalInit Optional init function for a specific framework SDK
 * @returns
 */
function init(options = {}, 
// This parameter name ensures that TypeScript error messages contain a hint for fixing SDK version mismatches
originalInit = browser.init) {
    // Ensure the browser SDK is only init'ed once.
    if (window?.__SENTRY__RENDERER_INIT__) {
        core.debug.warn(`The browser SDK has already been initialized.
If init has been called in the preload and contextIsolation is disabled, is not required to call init in the renderer`);
        return;
    }
    window.__SENTRY__RENDERER_INIT__ = true;
    // Disable client reports for renderer as the sdk should only send
    // events using the main process.
    options.sendClientReports = false;
    if (options.defaultIntegrations === undefined) {
        options.defaultIntegrations = getDefaultIntegrations(options);
    }
    if (options.stackParser === undefined) {
        options.stackParser = stackParse.electronRendererStackParser;
    }
    if (options.ipcNamespace === undefined) {
        options.ipcNamespace = 'sentry-ipc';
    }
    // eslint-disable-next-line deprecation/deprecation
    if (options.dsn === undefined) {
        // Events are sent via the main process but browser SDK wont start without dsn
        // eslint-disable-next-line deprecation/deprecation
        options.dsn = 'https://12345@dummy.dsn/12345';
    }
    if (options.transport === undefined) {
        options.transport = transport.makeRendererTransport;
    }
    // We only handle initialScope in the main process otherwise it can cause race conditions over IPC
    delete options.initialScope;
    originalInit(options);
}

exports.getDefaultIntegrations = getDefaultIntegrations;
exports.init = init;//# sourceMappingURL=http://go/sourcemap/sourcemaps/39a966b4048ef6b8024b27d4812a50d88de29cc0/node_modules/@sentry/electron/renderer/sdk.js.map
