"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getClientAttributes = void 0;
const semantic_conventions_1 = require("@opentelemetry/semantic-conventions");
const instrumentation_1 = require("@opentelemetry/instrumentation");
function getClientAttributes(diag, options, semconvStability) {
    const attributes = {};
    if (semconvStability & instrumentation_1.SemconvStability.OLD) {
        Object.assign(attributes, {
            [semantic_conventions_1.SEMATTRS_DB_SYSTEM]: semantic_conventions_1.DBSYSTEMVALUES_REDIS,
            [semantic_conventions_1.SEMATTRS_NET_PEER_NAME]: options?.socket?.host,
            [semantic_conventions_1.SEMATTRS_NET_PEER_PORT]: options?.socket?.port,
            [semantic_conventions_1.SEMATTRS_DB_CONNECTION_STRING]: removeCredentialsFromDBConnectionStringAttribute(diag, options?.url),
        });
    }
    if (semconvStability & instrumentation_1.SemconvStability.STABLE) {
        Object.assign(attributes, {
            [semantic_conventions_1.ATTR_DB_SYSTEM_NAME]: 'redis',
            [semantic_conventions_1.ATTR_SERVER_ADDRESS]: options?.socket?.host,
            [semantic_conventions_1.ATTR_SERVER_PORT]: options?.socket?.port,
        });
    }
    return attributes;
}
exports.getClientAttributes = getClientAttributes;
/**
 * removeCredentialsFromDBConnectionStringAttribute removes basic auth from url and user_pwd from query string
 *
 * Examples:
 *   redis://user:pass@localhost:6379/mydb => redis://localhost:6379/mydb
 *   redis://localhost:6379?db=mydb&user_pwd=pass => redis://localhost:6379?db=mydb
 */
function removeCredentialsFromDBConnectionStringAttribute(diag, url) {
    if (typeof url !== 'string' || !url) {
        return;
    }
    try {
        const u = new URL(url);
        u.searchParams.delete('user_pwd');
        u.username = '';
        u.password = '';
        return u.href;
    }
    catch (err) {
        diag.error('failed to sanitize redis connection url', err);
    }
    return;
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/39a966b4048ef6b8024b27d4812a50d88de29cc0/node_modules/@opentelemetry/instrumentation-redis/build/src/v4-v5/utils.js.map