const core = require('@sentry/core');
const ipc = require('../ipc.js');

const eventLoopBlockIntegration = core.defineIntegration((options) => {
    const anrThreshold = options?.threshold ?? 1000;
    const pollInterval = options?.pollInterval || anrThreshold / 2;
    return {
        name: 'EventLoopBlockRenderer',
        setup(client) {
            const config = {
                pollInterval,
                anrThreshold,
                captureStackTrace: true,
                ...options,
            };
            const ipc$1 = ipc.getIPC(client);
            // eslint-disable-next-line no-restricted-globals
            ipc$1.sendStatus({ status: document.visibilityState, config });
            setInterval(() => {
                ipc$1.sendStatus({ status: 'alive', config });
            }, config.pollInterval);
        },
    };
});

exports.eventLoopBlockIntegration = eventLoopBlockIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/39a966b4048ef6b8024b27d4812a50d88de29cc0/node_modules/@sentry/electron/renderer/integrations/event-loop-block.js.map
