import { createParser } from "./index.esm.js";
import { ParseError } from "./index.esm.js";
class EventSourceParserStream extends TransformStream {
  constructor({ onError, onRetry, onComment } = {}) {
    let parser;
    super({
      start(controller) {
        parser = createParser({
          onEvent: (event) => {
            controller.enqueue(event);
          },
          onError(error) {
            onError === "terminate" ? controller.error(error) : typeof onError == "function" && onError(error);
          },
          onRetry,
          onComment
        });
      },
      transform(chunk) {
        parser.feed(chunk);
      }
    });
  }
}
export {
  EventSourceParserStream,
  ParseError
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/34881053400013f38e2354f1479c88c9067039a0/node_modules/eventsource-parser/dist/stream.esm.js.map
