"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.windowCount = void 0;
const Observable_js_1 = require("../Observable.js");
const Subject_js_1 = require("../Subject.js");
function windowCount(windowSize, startWindowEvery = 0) {
    const startEvery = startWindowEvery > 0 ? startWindowEvery : windowSize;
    return (source) => new Observable_js_1.Observable((destination) => {
        let windows = [new Subject_js_1.Subject()];
        let starts = [];
        let count = 0;
        destination.next(windows[0].asObservable());
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                for (const window of windows) {
                    window.next(value);
                }
                const c = count - windowSize + 1;
                if (c >= 0 && c % startEvery === 0) {
                    windows.shift().complete();
                }
                if (++count % startEvery === 0) {
                    const window = new Subject_js_1.Subject();
                    windows.push(window);
                    destination.next(window.asObservable());
                }
            },
            error: (err) => {
                while (windows.length > 0) {
                    windows.shift().error(err);
                }
                destination.error(err);
            },
            complete: () => {
                while (windows.length > 0) {
                    windows.shift().complete();
                }
                destination.complete();
            },
            finalize: () => {
                starts = null;
                windows = null;
            },
        }));
    });
}
exports.windowCount = windowCount;//# sourceMappingURL=http://go/sourcemap/sourcemaps/32cfbe848b35d9eb320980195985450f244b3030/node_modules/rxjs/dist/cjs/internal/operators/windowCount.js.map