import { AsyncLocalStorageContextManager } from '@opentelemetry/context-async-hooks';
import { wrapContextManagerClass } from '@sentry/opentelemetry';

/**
 * This is a custom ContextManager for OpenTelemetry, which extends the default AsyncLocalStorageContextManager.
 * It ensures that we create a new hub per context, so that the OTEL Context & the Sentry Scopes are always in sync.
 *
 * Note that we currently only support AsyncHooks with this,
 * but since this should work for Node 14+ anyhow that should be good enough.
 */
const SentryContextManager = wrapContextManagerClass(AsyncLocalStorageContextManager);

export { SentryContextManager };//# sourceMappingURL=http://go/sourcemap/sourcemaps/31b1fbfcec1bf758f7140645f005fc78b5df3550/node_modules/@sentry/node-core/build/esm/otel/contextManager.js.map
