const core = require('@sentry/core');
const electron = require('electron');

/**
 * Captures and attaches screenshots to events
 */
const screenshotsIntegration = core.defineIntegration(() => {
    return {
        name: 'Screenshots',
        async processEvent(event, hint, client) {
            const attachScreenshot = !!client.getOptions().attachScreenshot;
            if (!attachScreenshot) {
                return event;
            }
            // We don't capture screenshots for transactions or native crashes
            if (!event.transaction && event.platform !== 'native') {
                let count = 1;
                for (const window of electron.BrowserWindow.getAllWindows()) {
                    if (!hint.attachments) {
                        hint.attachments = [];
                    }
                    try {
                        if (!window.isDestroyed() && window.isVisible()) {
                            const filename = count === 1 ? 'screenshot.png' : `screenshot-${count}.png`;
                            const image = await window.capturePage();
                            hint.attachments.push({ filename, data: image.toPNG(), contentType: 'image/png' });
                            count += 1;
                        }
                    }
                    catch (e) {
                        // Catch all errors so we don't break event submission if something goes wrong
                        core.debug.error('Error capturing screenshot', e);
                    }
                }
            }
            return event;
        },
    };
});

exports.screenshotsIntegration = screenshotsIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/31b1fbfcec1bf758f7140645f005fc78b5df3550/node_modules/@sentry/electron/main/integrations/screenshots.js.map
