import crypto from 'crypto';
import { coerce } from '../bytes.js';
import { from } from './hasher.js';
export const sha256 = from({
    name: 'sha2-256',
    code: 0x12,
    encode: (input) => coerce(crypto.createHash('sha256').update(input).digest())
});
export const sha512 = from({
    name: 'sha2-512',
    code: 0x13,
    encode: input => coerce(crypto.createHash('sha512').update(input).digest())
});//# sourceMappingURL=http://go/sourcemap/sourcemaps/31b1fbfcec1bf758f7140645f005fc78b5df3550/node_modules/multiformats/dist/src/hashes/sha2.js.map