"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HotObservable = void 0;
const Subject_js_1 = require("../Subject.js");
const Observable_js_1 = require("../Observable.js");
const Notification_js_1 = require("../Notification.js");
const subscription_logging_js_1 = require("./subscription-logging.js");
class HotObservable extends Subject_js_1.Subject {
    messages;
    scheduler;
    subscriptions = [];
    logSubscribedFrame = subscription_logging_js_1.logSubscribedFrame;
    logUnsubscribedFrame = subscription_logging_js_1.logUnsubscribedFrame;
    constructor(messages, scheduler) {
        super();
        this.messages = messages;
        this.scheduler = scheduler;
    }
    _subscribe(subscriber) {
        const index = this.logSubscribedFrame();
        const subscription = new Observable_js_1.Subscription();
        subscription.add(new Observable_js_1.Subscription(() => {
            this.logUnsubscribedFrame(index);
        }));
        subscription.add(super._subscribe(subscriber));
        return subscription;
    }
    setup() {
        for (const { notification, frame } of this.messages) {
            this.scheduler.schedule(() => {
                (0, Notification_js_1.observeNotification)(notification, this);
            }, frame);
        }
    }
}
exports.HotObservable = HotObservable;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2e353c5f5b30150ff7b874dee5a87660693d9de0/node_modules/rxjs/dist/cjs/internal/testing/HotObservable.js.map