import { Observable, operate } from '../Observable.js';
export function takeWhile(predicate, inclusive = false) {
    return (source) => new Observable((destination) => {
        let index = 0;
        const operatorSubscriber = operate({
            destination,
            next: (value) => {
                if (predicate(value, index++)) {
                    destination.next(value);
                }
                else {
                    operatorSubscriber.unsubscribe();
                    if (inclusive) {
                        destination.next(value);
                    }
                    destination.complete();
                }
            },
        });
        source.subscribe(operatorSubscriber);
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/2e353c5f5b30150ff7b874dee5a87660693d9de0/node_modules/rxjs/dist/esm/internal/operators/takeWhile.js.map