import { Observable, operate } from '../Observable.js';
export function takeWhile(predicate, inclusive = false) {
    return (source) => new Observable((destination) => {
        let index = 0;
        const operatorSubscriber = operate({
            destination,
            next: (value) => {
                if (predicate(value, index++)) {
                    destination.next(value);
                }
                else {
                    operatorSubscriber.unsubscribe();
                    if (inclusive) {
                        destination.next(value);
                    }
                    destination.complete();
                }
            },
        });
        source.subscribe(operatorSubscriber);
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/2d3ce3499c15efd55b6b8538ea255eb7ba4266b0/node_modules/rxjs/dist/esm/internal/operators/takeWhile.js.map