import { Observable, from, operate } from '../Observable.js';
import { noop } from '../util/noop.js';
export function sample(notifier) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        let lastValue = null;
        source.subscribe(operate({
            destination,
            next: (value) => {
                hasValue = true;
                lastValue = value;
            },
        }));
        from(notifier).subscribe(operate({
            destination,
            next: () => {
                if (hasValue) {
                    hasValue = false;
                    const value = lastValue;
                    lastValue = null;
                    destination.next(value);
                }
            },
            complete: noop,
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/2d3ce3499c15efd55b6b8538ea255eb7ba4266b0/node_modules/rxjs/dist/esm/internal/operators/sample.js.map