"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeScan = void 0;
const Observable_js_1 = require("../Observable.js");
const mergeInternals_js_1 = require("./mergeInternals.js");
function mergeScan(accumulator, seed, concurrent = Infinity) {
    return (source) => new Observable_js_1.Observable((subscriber) => {
        let state = seed;
        return (0, mergeInternals_js_1.mergeInternals)(source, subscriber, (value, index) => accumulator(state, value, index), concurrent, (value) => {
            state = value;
        }, false, undefined, () => (state = null));
    });
}
exports.mergeScan = mergeScan;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2d3ce3499c15efd55b6b8538ea255eb7ba4266b0/node_modules/rxjs/dist/cjs/internal/operators/mergeScan.js.map