Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const contextAsyncHooks = require('@opentelemetry/context-async-hooks');
const opentelemetry = require('@sentry/opentelemetry');

/**
 * This is a custom ContextManager for OpenTelemetry, which extends the default AsyncLocalStorageContextManager.
 * It ensures that we create a new hub per context, so that the OTEL Context & the Sentry Scopes are always in sync.
 *
 * Note that we currently only support AsyncHooks with this,
 * but since this should work for Node 14+ anyhow that should be good enough.
 */
const SentryContextManager = opentelemetry.wrapContextManagerClass(contextAsyncHooks.AsyncLocalStorageContextManager);

exports.SentryContextManager = SentryContextManager;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2d3ce3499c15efd55b6b8538ea255eb7ba4266b0/node_modules/@sentry/node-core/build/cjs/otel/contextManager.js.map
