Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const debugBuild = require('./debug-build.js');
const debugLogger = require('./utils/debug-logger.js');
const is = require('./utils/is.js');
const syncpromise = require('./utils/syncpromise.js');

/**
 * Process an array of event processors, returning the processed event (or `null` if the event was dropped).
 */
function notifyEventProcessors(
  processors,
  event,
  hint,
  index = 0,
) {
  try {
    const result = _notifyEventProcessors(event, hint, processors, index);
    return is.isThenable(result) ? result : syncpromise.resolvedSyncPromise(result);
  } catch (error) {
    return syncpromise.rejectedSyncPromise(error);
  }
}

function _notifyEventProcessors(
  event,
  hint,
  processors,
  index,
) {
  const processor = processors[index];

  if (!event || !processor) {
    return event;
  }

  const result = processor({ ...event }, hint);

  debugBuild.DEBUG_BUILD && result === null && debugLogger.debug.log(`Event processor "${processor.id || '?'}" dropped event`);

  if (is.isThenable(result)) {
    return result.then(final => _notifyEventProcessors(final, hint, processors, index + 1));
  }

  return _notifyEventProcessors(result, hint, processors, index + 1);
}

exports.notifyEventProcessors = notifyEventProcessors;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2d3ce3499c15efd55b6b8538ea255eb7ba4266b0/node_modules/@sentry/core/build/cjs/eventProcessors.js.map
