const { isArray } = Array;
const { getPrototypeOf, prototype: objectProto, keys: getKeys } = Object;
export function argsArgArrayOrObject(args) {
    if (args.length === 1) {
        const first = args[0];
        const result = arrayOrObject(first);
        if (result) {
            return result;
        }
    }
    return { args: args, keys: null };
}
export function arrayOrObject(first) {
    if (isArray(first)) {
        return { args: first, keys: null };
    }
    if (isPOJO(first)) {
        const keys = getKeys(first);
        return {
            args: keys.map((key) => first[key]),
            keys,
        };
    }
    return null;
}
function isPOJO(obj) {
    return obj && typeof obj === 'object' && getPrototypeOf(obj) === objectProto;
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/2d3ce3499c15efd55b6b8538ea255eb7ba4266b0/node_modules/rxjs/dist/esm/internal/util/argsArgArrayOrObject.js.map