"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.switchScan = void 0;
const switchMap_js_1 = require("./switchMap.js");
const Observable_js_1 = require("../Observable.js");
function switchScan(accumulator, seed) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let state = seed;
        (0, switchMap_js_1.switchMap)((value, index) => accumulator(state, value, index))(source).subscribe((0, Observable_js_1.operate)({
            destination,
            next: (innerValue) => {
                state = innerValue;
                destination.next(innerValue);
            },
        }));
        return () => {
            state = null;
        };
    });
}
exports.switchScan = switchScan;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2d3ce3499c15efd55b6b8538ea255eb7ba4266b0/node_modules/rxjs/dist/cjs/internal/operators/switchScan.js.map