import { asyncScheduler } from '../scheduler/async.js';
import { Observable, operate } from '../Observable.js';
export function timeInterval(scheduler = asyncScheduler) {
    return (source) => new Observable((destination) => {
        let last = scheduler.now();
        source.subscribe(operate({
            destination,
            next: (value) => {
                const now = scheduler.now();
                const interval = now - last;
                last = now;
                destination.next(new TimeInterval(value, interval));
            },
        }));
    });
}
export class TimeInterval {
    value;
    interval;
    constructor(value, interval) {
        this.value = value;
        this.interval = interval;
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/28e7b8993fa2568fb3cb377e67615eb068b893e0/node_modules/rxjs/dist/esm/internal/operators/timeInterval.js.map