import { operate, from, Observable } from '../Observable.js';
export function exhaustMap(project) {
    return (source) => new Observable((destination) => {
        let index = 0;
        let innerSub = null;
        let isComplete = false;
        source.subscribe(operate({
            destination,
            next: (outerValue) => {
                if (!innerSub) {
                    innerSub = operate({
                        destination,
                        complete: () => {
                            innerSub = null;
                            isComplete && destination.complete();
                        },
                    });
                    from(project(outerValue, index++)).subscribe(innerSub);
                }
            },
            complete: () => {
                isComplete = true;
                !innerSub && destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/28e7b8993fa2568fb3cb377e67615eb068b893e0/node_modules/rxjs/dist/esm/internal/operators/exhaustMap.js.map