"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.distinctUntilChanged = void 0;
const identity_js_1 = require("../util/identity.js");
const Observable_js_1 = require("../Observable.js");
function distinctUntilChanged(comparator, keySelector = identity_js_1.identity) {
    comparator = comparator ?? defaultCompare;
    return (source) => new Observable_js_1.Observable((destination) => {
        let previousKey;
        let first = true;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                const currentKey = keySelector(value);
                if (first || !comparator(previousKey, currentKey)) {
                    first = false;
                    previousKey = currentKey;
                    destination.next(value);
                }
            },
        }));
    });
}
exports.distinctUntilChanged = distinctUntilChanged;
function defaultCompare(a, b) {
    return a === b;
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/28e7b8993fa2568fb3cb377e67615eb068b893e0/node_modules/rxjs/dist/cjs/internal/operators/distinctUntilChanged.js.map