Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const api = require('@opentelemetry/api');
const core = require('@sentry/core');

/**
 * Setup the OTEL logger to use our own debug logger.
 */
function setupOpenTelemetryLogger() {
  // Disable diag, to ensure this works even if called multiple times
  api.diag.disable();
  api.diag.setLogger(
    {
      error: core.debug.error,
      warn: core.debug.warn,
      info: core.debug.log,
      debug: core.debug.log,
      verbose: core.debug.log,
    },
    api.DiagLogLevel.DEBUG,
  );
}

exports.setupOpenTelemetryLogger = setupOpenTelemetryLogger;//# sourceMappingURL=http://go/sourcemap/sourcemaps/28e7b8993fa2568fb3cb377e67615eb068b893e0/node_modules/@sentry/node-core/build/cjs/otel/logger.js.map
