import * as exports from './logs/exports.js';
export { exports as logger };
export { httpIntegration } from './integrations/http/index.js';
export { SentryHttpInstrumentation } from './integrations/http/SentryHttpInstrumentation.js';
export { nativeNodeFetchIntegration } from './integrations/node-fetch/index.js';
export { SentryNodeFetchInstrumentation } from './integrations/node-fetch/SentryNodeFetchInstrumentation.js';
export { nodeContextIntegration } from './integrations/context.js';
export { contextLinesIntegration } from './integrations/contextlines.js';
export { localVariablesIntegration } from './integrations/local-variables/index.js';
export { modulesIntegration } from './integrations/modules.js';
export { onUncaughtExceptionIntegration } from './integrations/onuncaughtexception.js';
export { onUnhandledRejectionIntegration } from './integrations/onunhandledrejection.js';
export { anrIntegration, disableAnrDetectionForCallback } from './integrations/anr/index.js';
export { spotlightIntegration } from './integrations/spotlight.js';
export { childProcessIntegration } from './integrations/childProcess.js';
export { createSentryWinstonTransport } from './integrations/winston.js';
export { SentryContextManager } from './otel/contextManager.js';
export { setupOpenTelemetryLogger } from './otel/logger.js';
export { INSTRUMENTED, generateInstrumentOnce, instrumentWhenWrapped } from './otel/instrument.js';
export { getDefaultIntegrations, init, initWithoutDefaultIntegrations, validateOpenTelemetrySetup } from './sdk/index.js';
export { setIsolationScope } from './sdk/scope.js';
export { defaultStackParser, getSentryRelease } from './sdk/api.js';
export { createGetModuleFromFilename } from './utils/module.js';
export { addOriginToSpan } from './utils/addOriginToSpan.js';
export { getRequestUrl } from './utils/getRequestUrl.js';
export { isCjs } from './utils/commonjs.js';
export { ensureIsWrapped } from './utils/ensureIsWrapped.js';
export { createMissingInstrumentationContext } from './utils/createMissingInstrumentationContext.js';
export { envToBool } from './utils/envToBool.js';
export { makeNodeTransport } from './transports/http.js';
export { NodeClient } from './sdk/client.js';
export { cron } from './cron/index.js';
export { NODE_VERSION } from './nodeVersion.js';
export { setOpenTelemetryContextAsyncContextStrategy as setNodeAsyncContextStrategy } from '@sentry/opentelemetry';
export { SDK_VERSION, SEMANTIC_ATTRIBUTE_SENTRY_OP, SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN, SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE, SEMANTIC_ATTRIBUTE_SENTRY_SOURCE, Scope, addBreadcrumb, addEventProcessor, addIntegration, captureCheckIn, captureConsoleIntegration, captureEvent, captureException, captureFeedback, captureMessage, captureSession, close, consoleIntegration, consoleLoggingIntegration, continueTrace, createTransport, dedupeIntegration, endSession, eventFiltersIntegration, extraErrorDataIntegration, featureFlagsIntegration, flush, functionToStringIntegration, getActiveSpan, getClient, getCurrentScope, getGlobalScope, getIsolationScope, getRootSpan, getSpanDescendants, getSpanStatusFromHttpCode, getTraceData, getTraceMetaTags, inboundFiltersIntegration, instrumentSupabaseClient, isEnabled, isInitialized, lastEventId, linkedErrorsIntegration, parameterize, profiler, requestDataIntegration, rewriteFramesIntegration, setContext, setCurrentClient, setExtra, setExtras, setHttpStatus, setMeasurement, setTag, setTags, setUser, spanToBaggageHeader, spanToJSON, spanToTraceHeader, startInactiveSpan, startNewTrace, startSession, startSpan, startSpanManual, supabaseIntegration, suppressTracing, trpcMiddleware, updateSpanName, withActiveSpan, withIsolationScope, withMonitor, withScope, wrapMcpServerWithSentry, zodErrorsIntegration } from '@sentry/core';//# sourceMappingURL=http://go/sourcemap/sourcemaps/26207e5ce5ec4988e596fb7dbc45e9133a06dc70/node_modules/@sentry/node-core/build/esm/index.js.map
