import { defineIntegration } from '@sentry/core';
import { app } from 'electron';

function gpuDeviceToGpuContext(device) {
    return {
        name: device.deviceString || 'GPU',
        active: device.active,
        id: `0x${device.deviceId.toString(16).padStart(4, '0')}`,
        vendor_id: `0x${device.vendorId.toString(16).padStart(4, '0')}`,
        vendor_name: device.vendorString,
        driver_version: device.driverVersion,
    };
}
/**
 * Adds GPU context to events
 */
const gpuContextIntegration = defineIntegration((options = { infoLevel: 'basic' }) => {
    let gpuContexts;
    return {
        name: 'GpuContext',
        processEvent: async (event) => {
            if (gpuContexts === undefined) {
                const result = (await app.getGPUInfo(options.infoLevel));
                gpuContexts = result.gpuDevice.map(gpuDeviceToGpuContext);
            }
            if (gpuContexts.length === 1) {
                event.contexts = { ...event.contexts, gpu: gpuContexts[0] };
            }
            else if (gpuContexts.length > 1) {
                event.contexts = { ...event.contexts };
                for (let i = 0; i < gpuContexts.length; i++) {
                    const gpuContext = gpuContexts[i];
                    gpuContext.type = 'gpu';
                    event.contexts[`gpu_${i + 1}`] = gpuContext;
                }
            }
            return event;
        },
    };
});

export { gpuContextIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/26207e5ce5ec4988e596fb7dbc45e9133a06dc70/node_modules/@sentry/electron/esm/main/integrations/gpu-context.js.map
