import z from 'zod';
import { defineBrowserTool } from '../utils/browser-tool.js';

export const browserConsoleMessages = defineBrowserTool({
	name: 'browser_console_messages',
	description: 'Returns all console messages',
	params: z.object({}),

	handle: async (context, params, response) => {
		const tab = context.currentTab();
		if (!tab) {
			throw new Error('No active tab available');
		}

		const messages = await tab.consoleMessages();
		messages.map(message => response.addResult(message.toString()));
	},
});
