(()=>{"use strict";var t={256:function(t,e,n){var r,o=this&&this.__createBinding||(Object.create?function(t,e,n,r){void 0===r&&(r=n);var o=Object.getOwnPropertyDescriptor(e,n);o&&!("get"in o?!e.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return e[n]}}),Object.defineProperty(t,r,o)}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]}),s=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),i=this&&this.__importStar||(r=function(t){return r=Object.getOwnPropertyNames||function(t){var e=[];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[e.length]=n);return e},r(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=r(t),i=0;i<n.length;i++)"default"!==n[i]&&o(e,t,n[i]);return s(e,t),e});Object.defineProperty(e,"__esModule",{value:!0}),e.activate=async function(t){l.CursorIDEBrowserLogger.init(),l.CursorIDEBrowserLogger.info("Cursor Browser Automation extension activated"),p=new d,await p.initialize();const e=a.cursor.registerMcpProvider(p);t.subscriptions.push(e);const n=a.commands.registerCommand("cursor.browserAutomation.reinjectUIScript",m);t.subscriptions.push(n),m().catch(()=>{})},e.deactivate=async function(){p&&(await p.dispose(),p=void 0)};const a=i(n(398)),l=n(377),c=n(654),u=n(756);class d{constructor(){this.id="cursor-ide-browser",this.featureGateName=void 0,this.tools=[{name:"browser_navigate",description:"Navigate to a URL",parameters:JSON.stringify({type:"object",properties:{url:{type:"string",description:"The URL to navigate to"}},required:["url"]})},{name:"browser_snapshot",description:"Capture accessibility snapshot of the current page, this is better than screenshot",parameters:JSON.stringify({type:"object",properties:{},required:[]})},{name:"browser_click",description:"Perform click on a web page",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},doubleClick:{type:"boolean",description:"Whether to perform a double click instead of a single click"},button:{type:"string",description:"Button to click, defaults to left"},modifiers:{type:"array",items:{type:"string"},description:"Modifier keys to press"}},required:["element","ref"]})},{name:"browser_type",description:"Type text into editable element",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},text:{type:"string",description:"Text to type into the element"},submit:{type:"boolean",description:"Whether to submit entered text (press Enter after)"},slowly:{type:"boolean",description:"Whether to type one character at a time. Useful for triggering key handlers in the page. By default entire text is filled in at once."}},required:["element","ref","text"]})},{name:"browser_hover",description:"Hover over element on page",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"}},required:["element","ref"]})},{name:"browser_select_option",description:"Select an option in a dropdown",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},values:{type:"array",items:{type:"string"},description:"Array of values to select in the dropdown. This can be a single value or multiple values."}},required:["element","ref","values"]})},{name:"browser_press_key",description:"Press a key on the keyboard",parameters:JSON.stringify({type:"object",properties:{key:{type:"string",description:"Name of the key to press or a character to generate, such as ArrowLeft or a"}},required:["key"]})},{name:"browser_wait_for",description:"Wait for text to appear or disappear or a specified time to pass",parameters:JSON.stringify({type:"object",properties:{time:{type:"number",description:"The time to wait in seconds"},text:{type:"string",description:"The text to wait for"},textGone:{type:"string",description:"The text to wait for to disappear"}},required:[]})},{name:"browser_navigate_back",description:"Go back to the previous page",parameters:JSON.stringify({type:"object",properties:{},required:[]})},{name:"browser_resize",description:"Resize the browser window",parameters:JSON.stringify({type:"object",properties:{width:{type:"number",description:"Width of the browser window"},height:{type:"number",description:"Height of the browser window"}},required:["width","height"]})},{name:"browser_console_messages",description:"Returns all console messages",parameters:JSON.stringify({type:"object",properties:{},required:[]})},{name:"browser_network_requests",description:"Returns all network requests since loading the page",parameters:JSON.stringify({type:"object",properties:{},required:[]})},{name:"browser_take_screenshot",description:"Take a screenshot of the current page. You can't perform actions based on the screenshot, use browser_snapshot for actions.",parameters:JSON.stringify({type:"object",properties:{type:{type:"string",description:"Image format for the screenshot. Default is png."},filename:{type:"string",description:"File name to save the screenshot to. Defaults to page-{timestamp}.{png|jpeg} if not specified."},element:{type:"string",description:"Description of the element, if taking a screenshot of an element"},ref:{type:"string",description:"CSS selector for the element, if taking a screenshot of an element"},fullPage:{type:"boolean",description:"When true, takes a screenshot of the full scrollable page, instead of the currently visible viewport. Cannot be used with element screenshots."}},required:[]})}]}async initialize(){l.CursorIDEBrowserLogger.info("Browser Automation MCP Provider initialized with direct execution")}async listOfferings(){return{tools:this.tools,prompts:[],resources:[]}}async callTool(t,e){l.CursorIDEBrowserLogger.info(`Executing tool: ${t} with args: ${JSON.stringify(e)}`);try{switch(t){case"browser_navigate":return await c.BrowserTools.navigate(e);case"browser_snapshot":return await c.BrowserTools.snapshot(e);case"browser_click":return await c.BrowserTools.click(e);case"browser_type":return await c.BrowserTools.type(e);case"browser_hover":return await c.BrowserTools.hover(e);case"browser_select_option":return await c.BrowserTools.selectOption(e);case"browser_press_key":return await c.BrowserTools.pressKey(e);case"browser_wait_for":return await c.BrowserTools.waitFor(e);case"browser_navigate_back":return await c.BrowserTools.goBack(e);case"browser_resize":return await c.BrowserTools.resize(e);case"browser_console_messages":return await c.BrowserTools.consoleMessages(e);case"browser_network_requests":return await c.BrowserTools.networkRequests(e);case"browser_take_screenshot":return await c.BrowserTools.takeScreenshot(e);default:throw new Error(`Unknown tool: ${t}`)}}catch(e){throw l.CursorIDEBrowserLogger.error(`Error executing tool ${t}:`,e),e}}async dispose(){l.CursorIDEBrowserLogger.info("Browser Automation MCP Provider disposed")}}let p;async function m(){try{const t=(0,u.generateBrowserUIScript)("browser-tab-id");await a.commands.executeCommand("cursor.browserView.executeJavaScript",t),l.CursorIDEBrowserLogger.info("Browser UI script injected successfully")}catch(t){l.CursorIDEBrowserLogger.error("Failed to inject browser UI script:",t)}}},377:function(t,e,n){var r,o=this&&this.__createBinding||(Object.create?function(t,e,n,r){void 0===r&&(r=n);var o=Object.getOwnPropertyDescriptor(e,n);o&&!("get"in o?!e.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return e[n]}}),Object.defineProperty(t,r,o)}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]}),s=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),i=this&&this.__importStar||(r=function(t){return r=Object.getOwnPropertyNames||function(t){var e=[];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[e.length]=n);return e},r(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=r(t),i=0;i<n.length;i++)"default"!==n[i]&&o(e,t,n[i]);return s(e,t),e});Object.defineProperty(e,"__esModule",{value:!0}),e.CursorIDEBrowserLogger=void 0;const a=i(n(398));class l{constructor(t){this.identifier=t}static init(){this.outputChannel||(this.outputChannel=a.window.createOutputChannel("Cursor IDE Browser Automation"))}static getLogger(t){return this.loggers.has(t)||this.loggers.set(t,new l(t)),this.loggers.get(t)}static info(t){this.log("INFO","general",t)}static warn(t){this.log("WARN","general",t)}static error(t,e){const n=e?`${t}: ${e.message}`:t;this.log("ERROR","general",n),e?.stack&&this.log("ERROR","general",e.stack)}info(t){l.log("INFO",this.identifier,t)}warn(t){l.log("WARN",this.identifier,t)}error(t,e){const n=e?`${t}: ${e.message}`:t;l.log("ERROR",this.identifier,n),e?.stack&&l.log("ERROR",this.identifier,e.stack)}static log(t,e,n){if(this.outputChannel){const r=(new Date).toISOString();this.outputChannel.appendLine(`[${r}] [${t}] [${e}] ${n}`)}}}e.CursorIDEBrowserLogger=l,l.loggers=new Map},398:t=>{t.exports=require("vscode")},654:function(t,e,n){var r,o=this&&this.__createBinding||(Object.create?function(t,e,n,r){void 0===r&&(r=n);var o=Object.getOwnPropertyDescriptor(e,n);o&&!("get"in o?!e.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return e[n]}}),Object.defineProperty(t,r,o)}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]}),s=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),i=this&&this.__importStar||(r=function(t){return r=Object.getOwnPropertyNames||function(t){var e=[];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[e.length]=n);return e},r(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=r(t),i=0;i<n.length;i++)"default"!==n[i]&&o(e,t,n[i]);return s(e,t),e});Object.defineProperty(e,"__esModule",{value:!0}),e.BrowserTools=void 0;const a=i(n(398)),l=i(n(943)),c=i(n(928)),u=i(n(857)),d=n(377),p=c.join(u.homedir(),".cursor","browser-logs");function m(t,e=0){const n="  ".repeat(e),r=[];if(t.role&&r.push(`${n}- role: ${t.role}`),t.name){const e=String(t.name).replace(/\n/g," ").trim();e.includes(":")||e.includes('"')||e.includes("[")?r.push(`${n}  name: "${e.replace(/"/g,'\\"')}"`):r.push(`${n}  name: ${e}`)}if(t.ref&&r.push(`${n}  ref: ${t.ref}`),t.children&&t.children.length>0){r.push(`${n}  children:`);for(const n of t.children)r.push(m(n,e+2))}return r.join("\n")}const f="\nfunction buildPageSnapshot(depth = 0, maxDepth = 20) {\n    function getTextFromIds(ids) {\n        try {\n            if (!ids) return '';\n            const parts = [];\n            ids.split(/s+/).forEach(id => {\n                const el = document.getElementById(id);\n                if (el) {\n                    const t = (el.innerText || el.textContent || '').trim();\n                    if (t) parts.push(t);\n                }\n            });\n            return parts.join(' ').trim();\n        } catch (_) { return ''; }\n    }\n\n    function getVisibleText(el) {\n        try {\n            const walker = document.createTreeWalker(\n                el,\n                NodeFilter.SHOW_TEXT,\n                {\n                    acceptNode(node) {\n                        if (!node.textContent || !node.textContent.trim()) {\n                            return NodeFilter.FILTER_REJECT;\n                        }\n                        const parent = node.parentElement;\n                        if (parent) {\n                            const style = window.getComputedStyle(parent);\n                            if (style && (style.visibility === 'hidden' || style.display === 'none')) {\n                                return NodeFilter.FILTER_REJECT;\n                            }\n                        }\n                        return NodeFilter.FILTER_ACCEPT;\n                    }\n                }\n            );\n            const parts = [];\n            while (walker.nextNode()) {\n                const text = walker.currentNode.textContent || '';\n                const clean = text.replace(/s+/g, ' ').trim();\n                if (clean) {\n                    parts.push(clean);\n                    if (parts.join(' ').length > 240) {\n                        break;\n                    }\n                }\n            }\n            if (parts.length) {\n                return parts.join(' ').trim().substring(0, 200);\n            }\n            const fallback = (el.innerText || el.textContent || '').replace(/s+/g, ' ').trim();\n            return fallback.substring(0, 200);\n        } catch (_) {\n            try {\n                const text = (el.innerText || '').replace(/s+/g, ' ').trim();\n                return text.substring(0, 200);\n            } catch (_) {\n                return '';\n            }\n        }\n    }\n\n    function getLabelsText(el) {\n        try {\n            const labels = (el.labels && Array.from(el.labels)) || [];\n            if (!labels.length) return '';\n            const labelText = labels\n                .map(label => getVisibleText(label) || (label.textContent || '').trim())\n                .filter(Boolean)\n                .join(' ')\n                .trim();\n            return labelText.substring(0, 200);\n        } catch (_) {\n            return '';\n        }\n    }\n\n    function getImplicitRole(el) {\n        try {\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n            switch (tag) {\n                case 'a':\n                    return el.hasAttribute('href') ? 'link' : 'generic';\n                case 'button':\n                    return 'button';\n                case 'input': {\n                    const type = (el.getAttribute('type') || 'text').toLowerCase();\n                    switch (type) {\n                        case 'button':\n                        case 'submit':\n                        case 'reset':\n                            return 'button';\n                        case 'checkbox':\n                            return 'checkbox';\n                        case 'radio':\n                            return 'radio';\n                        case 'range':\n                            return 'slider';\n                        case 'number':\n                            return 'spinbutton';\n                        default:\n                            return 'textbox';\n                    }\n                }\n                case 'select':\n                    return el.hasAttribute('multiple') || Number(el.getAttribute('size') || 0) > 1 ? 'listbox' : 'combobox';\n                case 'option':\n                    return 'option';\n                case 'textarea':\n                    return 'textbox';\n                case 'img':\n                    return 'img';\n                case 'ul':\n                case 'ol':\n                    return 'list';\n                case 'li':\n                    return 'listitem';\n                case 'nav':\n                    return 'navigation';\n                case 'main':\n                    return 'main';\n                case 'header':\n                    return 'banner';\n                case 'footer':\n                    return 'contentinfo';\n                case 'form':\n                    return 'form';\n                case 'table':\n                    return 'table';\n                case 'tr':\n                    return 'row';\n                case 'td':\n                    return 'cell';\n                case 'th':\n                    return 'columnheader';\n                case 'section':\n                case 'article':\n                case 'aside':\n                    return tag;\n                case 'summary':\n                    return 'button';\n                case 'details':\n                    return 'group';\n                case 'progress':\n                    return 'progressbar';\n                case 'meter':\n                    return 'meter';\n                case 'label':\n                    return 'label';\n                case 'h1':\n                case 'h2':\n                case 'h3':\n                case 'h4':\n                case 'h5':\n                case 'h6':\n                    return 'heading';\n                case 'svg':\n                    return 'img';\n                default:\n                    return 'generic';\n            }\n        } catch (_) {\n            return 'generic';\n        }\n    }\n\n    function computeAccessibleName(el, role) {\n        try {\n            if (!el || el.getAttribute('aria-hidden') === 'true') {\n                return '';\n            }\n\n            const labelledBy = el.getAttribute('aria-labelledby');\n            const fromLabelledBy = getTextFromIds(labelledBy);\n            if (fromLabelledBy) return fromLabelledBy.substring(0, 200);\n\n            const ariaLabel = (el.getAttribute('aria-label') || '').trim();\n            if (ariaLabel) return ariaLabel.substring(0, 200);\n\n            const ariaPlaceholder = (el.getAttribute('aria-placeholder') || '').trim();\n            if (ariaPlaceholder) return ariaPlaceholder.substring(0, 200);\n\n            const labelsText = getLabelsText(el);\n            if (labelsText) return labelsText.substring(0, 200);\n\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n\n            if (tag === 'img') {\n                const alt = (el.getAttribute('alt') || '').trim();\n                if (alt) return alt.substring(0, 200);\n            }\n\n            if (tag === 'input') {\n                const type = (el.getAttribute('type') || 'text').toLowerCase();\n                const value = el.value || el.getAttribute('value') || '';\n                const placeholder = (el.getAttribute('placeholder') || '').trim();\n                if (type === 'button' || type === 'submit' || type === 'reset') {\n                    if (value) return String(value).substring(0, 200);\n                }\n                if (placeholder) return placeholder.substring(0, 200);\n                if (value && type !== 'password') return String(value).substring(0, 200);\n            }\n\n            if (tag === 'textarea') {\n                const placeholder = (el.getAttribute('placeholder') || '').trim();\n                if (placeholder) return placeholder.substring(0, 200);\n                if (el.value) return String(el.value).substring(0, 200);\n            }\n\n            if (tag === 'select') {\n                const selected = Array.from(el.selectedOptions || [])\n                    .map(option => getVisibleText(option) || (option.textContent || '').trim())\n                    .filter(Boolean)\n                    .join(', ')\n                    .trim();\n                if (selected) return selected.substring(0, 200);\n            }\n\n            const roleLower = (role || '').toLowerCase();\n            const interactiveRoles = new Set(['button', 'link', 'menuitem', 'option', 'tab', 'checkbox', 'radio', 'switch', 'combobox', 'textbox', 'listbox', 'slider', 'spinbutton', 'cell', 'gridcell', 'row', 'columnheader', 'rowheader']);\n            const interactiveTags = new Set(['button', 'a', 'summary', 'label', 'option', 'textarea', 'select', 'time']);\n            const headingTags = new Set(['h1','h2','h3','h4','h5','h6']);\n            if (interactiveRoles.has(roleLower) || interactiveTags.has(tag) || headingTags.has(tag)) {\n                const visible = getVisibleText(el);\n                if (visible) return visible.substring(0, 200);\n            }\n\n            if (tag === 'p' || tag === 'li' || roleLower === 'heading') {\n                const visible = getVisibleText(el);\n                if (visible) return visible.substring(0, 200);\n            }\n\n            const title = (el.getAttribute('title') || '').trim();\n            if (title) return title.substring(0, 200);\n\n            return '';\n        } catch (_) {\n            return '';\n        }\n    }\n\n    function collectElementStates(el, role) {\n        const states = [];\n        try {\n            if (document.activeElement === el) states.push('focused');\n            if (el.matches && el.matches(':checked')) states.push('checked');\n            if (el.matches && el.matches(':disabled')) states.push('disabled');\n            if (el.matches && el.matches(':required')) states.push('required');\n            if (el.matches && el.matches(':read-only')) states.push('readonly');\n            if (el.selected) states.push('selected');\n            const ariaSelected = el.getAttribute('aria-selected');\n            if (ariaSelected === 'true') states.push('selected');\n            const ariaExpanded = el.getAttribute('aria-expanded');\n            if (ariaExpanded === 'true') states.push('expanded');\n            if (ariaExpanded === 'false') states.push('collapsed');\n            const ariaPressed = el.getAttribute('aria-pressed');\n            if (ariaPressed === 'true') states.push('pressed');\n            if (ariaPressed === 'false') states.push('released');\n            if (el.getAttribute && el.getAttribute('aria-current')) states.push('current');\n            if (el.getAttribute && el.getAttribute('aria-invalid') === 'true') states.push('invalid');\n            if (el.getAttribute && el.getAttribute('aria-busy') === 'true') states.push('busy');\n        } catch (_) { }\n        return Array.from(new Set(states));\n    }\n\n    function collectElementDetails(el, role) {\n        const details = {};\n        try {\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n            const ariaDescription = (el.getAttribute('aria-description') || '').trim();\n            if (ariaDescription) {\n                details.description = ariaDescription.substring(0, 200);\n            }\n            const describedBy = getTextFromIds(el.getAttribute('aria-describedby'));\n            if (describedBy) {\n                details.description = details.description\n                    ? (details.description + ' ' + describedBy.substring(0, 200)).trim()\n                    : describedBy.substring(0, 200);\n            }\n            if (tag === 'a' && el.hasAttribute('href')) {\n                details.url = el.getAttribute('href');\n            }\n            if ((tag === 'img' || tag === 'svg') && el.hasAttribute('src')) {\n                details.src = el.getAttribute('src');\n            }\n            if (tag === 'input' || tag === 'textarea') {\n                const type = (el.getAttribute('type') || 'text').toLowerCase();\n                const value = el.value || el.getAttribute('value') || '';\n                if (value && (tag !== 'input' || type !== 'password')) {\n                    details.value = String(value).substring(0, 200);\n                }\n                const placeholder = (el.getAttribute('placeholder') || '').trim();\n                if (placeholder) {\n                    details.placeholder = placeholder.substring(0, 200);\n                }\n            }\n            if (tag === 'select') {\n                const selected = Array.from(el.selectedOptions || [])\n                    .map(option => getVisibleText(option) || (option.textContent || '').trim())\n                    .filter(Boolean);\n                if (selected.length) {\n                    details.value = selected.join(', ').substring(0, 200);\n                }\n            }\n            if (role === 'combobox' && el.getAttribute('aria-activedescendant')) {\n                details.activeDescendant = el.getAttribute('aria-activedescendant');\n            }\n        } catch (_) { }\n        return details;\n    }\n\n    function shouldIncludeElement(el) {\n        try {\n            if (!el || el.getAttribute('aria-hidden') === 'true') {\n                return false;\n            }\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n            const role = el.getAttribute('role') || getImplicitRole(el);\n            const meaningfulTags = new Set(['a', 'button', 'input', 'select', 'textarea', 'img', 'svg', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'nav', 'main', 'header', 'footer', 'section', 'article', 'form', 'label', 'ul', 'ol', 'li', 'p', 'strong', 'em', 'small', 'time', 'option', 'summary', 'details']);\n            if (meaningfulTags.has(tag)) {\n                return true;\n            }\n            if (role && role !== 'generic') {\n                return true;\n            }\n            if (el.getAttribute('aria-label') || el.getAttribute('aria-labelledby')) {\n                return true;\n            }\n            if (el.matches && el.matches('[contenteditable=\"true\"]')) {\n                return true;\n            }\n            if (el.querySelector && el.querySelector('a, button, input, select, textarea, [role], [contenteditable=\"true\"]')) {\n                return true;\n            }\n        } catch (_) {\n            return true;\n        }\n        return false;\n    }\n\n    function buildAccessibilityTree(element, depth = 0, maxDepth = 20) {\n        if (!element || depth > maxDepth) return null;\n\n        let ref = element.getAttribute && element.getAttribute('data-cursor-ref');\n        if (!ref && element.setAttribute) {\n            ref = 'ref-' + Math.random().toString(36).substring(2, 15);\n            element.setAttribute('data-cursor-ref', ref);\n        }\n\n        const tag = element.tagName ? element.tagName.toLowerCase() : 'generic';\n        const roleAttr = (element.getAttribute && element.getAttribute('role')) || '';\n        const implicitRole = getImplicitRole(element);\n        const role = (roleAttr || implicitRole || tag || 'generic');\n        const name = computeAccessibleName(element, role);\n\n        const node = {\n            ref,\n            role,\n            name,\n            tag,\n            children: []\n        };\n\n        if (role === 'heading') {\n            const ariaLevel = parseInt(element.getAttribute('aria-level') || '', 10);\n            const tagLevelMatch = tag.match(/^h([1-6])$/);\n            const tagLevel = tagLevelMatch ? parseInt(tagLevelMatch[1], 10) : undefined;\n            const level = !Number.isNaN(ariaLevel) ? ariaLevel : tagLevel;\n            if (level) {\n                node.level = level;\n            }\n        }\n\n        const states = collectElementStates(element, role);\n        if (states.length) {\n            node.states = states;\n        }\n\n        const details = collectElementDetails(element, role);\n        for (const key in details) {\n            if (Object.prototype.hasOwnProperty.call(details, key) && details[key] !== undefined && details[key] !== '') {\n                node[key] = details[key];\n            }\n        }\n\n        const children = [];\n        if (element.children) {\n            for (const child of Array.from(element.children)) {\n                if (!shouldIncludeElement(child)) {\n                    continue;\n                }\n                const childNode = buildAccessibilityTree(child, depth + 1, maxDepth);\n                if (childNode) {\n                    children.push(childNode);\n                }\n            }\n        }\n\n        node.children = children;\n        return node;\n    }\n\n    return buildAccessibilityTree(document.body, depth, maxDepth);\n}\n";async function g(t){try{return await a.commands.executeCommand("cursor.browserView.executeJavaScript",t)}catch(t){throw d.CursorIDEBrowserLogger.error("Failed to execute JavaScript in browser:",t),t}}e.BrowserTools={navigate:async t=>(d.CursorIDEBrowserLogger.info(`Navigating to ${t.url}`),await a.commands.executeCommand("cursor.browserView.navigate",t.url),await new Promise(t=>setTimeout(t,1e3)),await e.BrowserTools.snapshot({})),async snapshot(t){const e=`\n\t\t\t${f}\n\t\t\t(function() {\n\t\t\t\tconst tree = buildPageSnapshot();\n\t\t\t\treturn {\n\t\t\t\t\taction: 'snapshot',\n\t\t\t\t\tsuccess: true,\n\t\t\t\t\tpageState: {\n\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\tsnapshot: tree\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t})();\n\t\t`,n=await g(e);if(n?.pageState?.snapshot){const t=m(n.pageState.snapshot),e=n.pageState.url,r=n.pageState.title,o=Buffer.byteLength(t,"utf8");if(o>25600)try{const{filePath:n,previewLines:s,totalLines:i}=await async function(t){await l.mkdir(p,{recursive:!0});const e=`snapshot-${(new Date).toISOString().replace(/[:.]/g,"-")}.log`,n=c.join(p,e),r=t.split("\n"),o=r.length,s=r.slice(0,Math.min(50,o));return await l.writeFile(n,t,"utf8"),d.CursorIDEBrowserLogger.info(`Large snapshot redirected to: ${n} (${o} lines, ${s.length} preview lines)`),{filePath:n,previewLines:s,totalLines:o}}(t),a=[];return a.push("\n\n### Page state",`- Page URL: ${e}`,`- Page Title: ${r}`,`- Page Snapshot: Large snapshot (${o} bytes, ${i} lines) written to file`,`- Snapshot File: [${n}](file://${n})`,`- Preview (first ${s.length} lines):`,"```yaml",s.join("\n"),"```",`\n... (${i-s.length} more lines in file)`),{action:"snapshot",success:!0,content:[{type:"text",text:a.join("\n")}]}}catch(t){d.CursorIDEBrowserLogger.error("Failed to write snapshot to file, returning inline:",t)}const s=[];return s.push("\n\n### Page state",`- Page URL: ${e}`,`- Page Title: ${r}`,"- Page Snapshot:","```yaml",t,"```"),{action:"snapshot",success:!0,content:[{type:"text",text:s.join("\n")}]}}return n},async click(t){const e=`\n\t\t\t${f}\n\t\t\t(function() {\n\t\t\t\tconst ref = ${JSON.stringify(t.ref)};\n\t\t\t\tconst element = document.querySelector('[data-cursor-ref="' + ref + '"]');\n\t\t\t\tif (!element) throw new Error('Element not found');\n\n\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\tconst cx = Math.round(rect.left + rect.width / 2);\n\t\t\t\tconst cy = Math.round(rect.top + rect.height / 2);\n\n\t\t\t\t// Scroll into view if needed\n\t\t\t\tif (rect.top < 0 || rect.left < 0 || rect.bottom > window.innerHeight || rect.right > window.innerWidth) {\n\t\t\t\t\telement.scrollIntoView({ block: 'center', inline: 'center', behavior: 'auto' });\n\t\t\t\t}\n\n\t\t\t\tconst buttonValue = ${JSON.stringify(t.button)} === 'right' ? 2 :\n\t\t\t\t\t${JSON.stringify(t.button)} === 'middle' ? 1 : 0;\n\n\t\t\t\tconst modifiers = ${JSON.stringify(t.modifiers||[])};\n\t\t\t\tconst mouseEventOptions = {\n\t\t\t\t\tbubbles: true,\n\t\t\t\t\tcancelable: true,\n\t\t\t\t\tview: window,\n\t\t\t\t\tbutton: buttonValue,\n\t\t\t\t\tbuttons: 1 << buttonValue,\n\t\t\t\t\tctrlKey: modifiers.includes('Control') || modifiers.includes('ControlOrMeta'),\n\t\t\t\t\tshiftKey: modifiers.includes('Shift'),\n\t\t\t\t\taltKey: modifiers.includes('Alt'),\n\t\t\t\t\tmetaKey: modifiers.includes('Meta') || modifiers.includes('ControlOrMeta'),\n\t\t\t\t\tclientX: cx,\n\t\t\t\t\tclientY: cy\n\t\t\t\t};\n\n\t\t\t\tif (element.focus) element.focus();\n\n\t\t\t\telement.dispatchEvent(new MouseEvent('mousedown', mouseEventOptions));\n\t\t\t\telement.dispatchEvent(new MouseEvent('mouseup', mouseEventOptions));\n\t\t\t\telement.dispatchEvent(new MouseEvent('click', mouseEventOptions));\n\n\t\t\t\tif (${JSON.stringify(t.doubleClick)}) {\n\t\t\t\t\telement.dispatchEvent(new MouseEvent('mousedown', mouseEventOptions));\n\t\t\t\t\telement.dispatchEvent(new MouseEvent('mouseup', mouseEventOptions));\n\t\t\t\t\telement.dispatchEvent(new MouseEvent('click', mouseEventOptions));\n\t\t\t\t\telement.dispatchEvent(new MouseEvent('dblclick', mouseEventOptions));\n\t\t\t\t}\n\n\t\t\t\tconst snapshot = buildPageSnapshot();\n\t\t\t\treturn {\n\t\t\t\t\taction: 'click',\n\t\t\t\t\tsuccess: true,\n\t\t\t\t\tdetails: {\n\t\t\t\t\t\tdoubleClick: ${JSON.stringify(t.doubleClick)} || false,\n\t\t\t\t\t\tbutton: ${JSON.stringify(t.button)} || 'left'\n\t\t\t\t\t},\n\t\t\t\t\tpageState: {\n\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\tsnapshot: snapshot\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t})();\n\t\t`;return await g(e)},async type(t){const e=`\n\t\t\t${f}\n\t\t\t(function() {\n\t\t\t\tconst ref = ${JSON.stringify(t.ref)};\n\t\t\t\tconst element = document.querySelector('[data-cursor-ref="' + ref + '"]');\n\t\t\t\tif (!element) throw new Error('Element not found');\n\n\t\t\t\telement.focus();\n\t\t\t\tconst text = ${JSON.stringify(t.text)};\n\t\t\t\tconst slowly = ${JSON.stringify(t.slowly)} || false;\n\t\t\t\tconst submit = ${JSON.stringify(t.submit)} || false;\n\n\t\t\t\tconst isContentEditable = element.isContentEditable;\n\n\t\t\t\tif (slowly) {\n\t\t\t\t\t// Type one character at a time\n\t\t\t\t\tconst delay = 50;\n\t\t\t\t\tfor (let i = 0; i < text.length; i++) {\n\t\t\t\t\t\tconst char = text[i];\n\t\t\t\t\t\tif (isContentEditable) {\n\t\t\t\t\t\t\tconst selection = window.getSelection();\n\t\t\t\t\t\t\tconst range = document.createRange();\n\t\t\t\t\t\t\trange.selectNodeContents(element);\n\t\t\t\t\t\t\trange.collapse(false);\n\t\t\t\t\t\t\tselection.removeAllRanges();\n\t\t\t\t\t\t\tselection.addRange(range);\n\t\t\t\t\t\t\tdocument.execCommand('insertText', false, char);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\telement.value = text.substring(0, i + 1);\n\t\t\t\t\t\t}\n\t\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keydown', { key: char, bubbles: true, cancelable: true }));\n\t\t\t\t\t\telement.dispatchEvent(new Event('input', { bubbles: true }));\n\t\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keyup', { key: char, bubbles: true, cancelable: true }));\n\t\t\t\t\t\t// Small delay between characters\n\t\t\t\t\t\tconst startTime = Date.now();\n\t\t\t\t\t\twhile (Date.now() - startTime < delay) { /* busy wait */ }\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tif (isContentEditable) {\n\t\t\t\t\t\telement.textContent = text;\n\t\t\t\t\t} else {\n\t\t\t\t\t\telement.value = text;\n\t\t\t\t\t}\n\t\t\t\t\telement.dispatchEvent(new Event('input', { bubbles: true }));\n\t\t\t\t}\n\n\t\t\t\telement.dispatchEvent(new Event('change', { bubbles: true }));\n\n\t\t\t\tif (submit) {\n\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keydown', { key: 'Enter', keyCode: 13, code: 'Enter', which: 13, bubbles: true, cancelable: true }));\n\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keypress', { key: 'Enter', keyCode: 13, code: 'Enter', which: 13, bubbles: true, cancelable: true }));\n\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keyup', { key: 'Enter', keyCode: 13, code: 'Enter', which: 13, bubbles: true, cancelable: true }));\n\t\t\t\t}\n\n\t\t\t\tconst snapshot = buildPageSnapshot();\n\t\t\t\treturn {\n\t\t\t\t\taction: 'type',\n\t\t\t\t\tsuccess: true,\n\t\t\t\t\tdetails: { slowly, submitted: submit },\n\t\t\t\t\tpageState: {\n\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\tsnapshot: snapshot\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t})();\n\t\t`;return await g(e)},async hover(t){const e=`\n\t\t\t${f}\n\t\t\t(function() {\n\t\t\t\tconst ref = ${JSON.stringify(t.ref)};\n\t\t\t\tconst element = document.querySelector('[data-cursor-ref="' + ref + '"]');\n\t\t\t\tif (!element) throw new Error('Element not found');\n\n\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\tconst hx = Math.round(rect.left + rect.width / 2);\n\t\t\t\tconst hy = Math.round(rect.top + rect.height / 2);\n\n\t\t\t\tconst mouseEventOptions = {\n\t\t\t\t\tbubbles: true,\n\t\t\t\t\tcancelable: true,\n\t\t\t\t\tview: window\n\t\t\t\t};\n\n\t\t\t\telement.dispatchEvent(new MouseEvent('mouseenter', { ...mouseEventOptions, clientX: hx, clientY: hy }));\n\t\t\t\telement.dispatchEvent(new MouseEvent('mouseover', { ...mouseEventOptions, clientX: hx, clientY: hy }));\n\t\t\t\telement.dispatchEvent(new MouseEvent('mousemove', { ...mouseEventOptions, clientX: hx, clientY: hy }));\n\n\t\t\t\tconst snapshot = buildPageSnapshot();\n\t\t\t\treturn {\n\t\t\t\t\taction: 'hover',\n\t\t\t\t\tsuccess: true,\n\t\t\t\t\tpageState: {\n\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\tsnapshot: snapshot\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t})();\n\t\t`;return await g(e)},async selectOption(t){const e=`\n\t\t\t${f}\n\t\t\t(function() {\n\t\t\t\tconst ref = ${JSON.stringify(t.ref)};\n\t\t\t\tconst element = document.querySelector('[data-cursor-ref="' + ref + '"]');\n\t\t\t\tif (!element) throw new Error('Element not found');\n\n\t\t\t\tconst selectElement = element;\n\t\t\t\tconst values = ${JSON.stringify(t.values)};\n\n\t\t\t\tif (!selectElement.multiple) {\n\t\t\t\t\tselectElement.value = '';\n\t\t\t\t} else {\n\t\t\t\t\tArray.from(selectElement.options).forEach(option => {\n\t\t\t\t\t\toption.selected = false;\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tconst selectedValues = [];\n\t\t\t\tfor (const value of values) {\n\t\t\t\t\tlet optionFound = false;\n\t\t\t\t\tfor (const option of selectElement.options) {\n\t\t\t\t\t\tif (option.value === value) {\n\t\t\t\t\t\t\toption.selected = true;\n\t\t\t\t\t\t\tselectedValues.push(value);\n\t\t\t\t\t\t\toptionFound = true;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif (!optionFound) {\n\t\t\t\t\t\tthrow new Error('Option with value "' + value + '" not found');\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tselectElement.dispatchEvent(new Event('input', { bubbles: true }));\n\t\t\t\tselectElement.dispatchEvent(new Event('change', { bubbles: true }));\n\n\t\t\t\tconst snapshot = buildPageSnapshot();\n\t\t\t\treturn {\n\t\t\t\t\taction: 'select_option',\n\t\t\t\t\tsuccess: true,\n\t\t\t\t\tdetails: { selectedValues },\n\t\t\t\t\tpageState: {\n\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\tsnapshot: snapshot\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t})();\n\t\t`;return await g(e)},async pressKey(t){const e=`\n\t\t\t(function() {\n\t\t\t\tconst key = ${JSON.stringify(t.key)};\n\t\t\t\tconst activeElement = document.activeElement || document.body;\n\n\t\t\t\tactiveElement.dispatchEvent(new KeyboardEvent('keydown', { key, bubbles: true, cancelable: true }));\n\t\t\t\tactiveElement.dispatchEvent(new KeyboardEvent('keypress', { key, bubbles: true, cancelable: true }));\n\t\t\t\tactiveElement.dispatchEvent(new KeyboardEvent('keyup', { key, bubbles: true, cancelable: true }));\n\n\t\t\t\treturn { action: 'press_key', success: true, key };\n\t\t\t})();\n\t\t`;return await g(e)},async waitFor(t){if(void 0!==t.time)return await new Promise(e=>setTimeout(e,1e3*t.time)),{action:"wait_for",success:!0,type:"time",duration:t.time};const e=`\n\t\t\t(function() {\n\t\t\t\tconst targetText = ${JSON.stringify(t.text||t.textGone)};\n\t\t\t\tconst waitForDisappear = ${JSON.stringify(!!t.textGone)};\n\t\t\t\tconst timeout = 30000;\n\t\t\t\tconst startTime = Date.now();\n\n\t\t\t\treturn new Promise((resolve) => {\n\t\t\t\t\tconst checkInterval = setInterval(() => {\n\t\t\t\t\t\tconst bodyText = document.body.innerText || document.body.textContent || '';\n\t\t\t\t\t\tconst found = bodyText.includes(targetText);\n\n\t\t\t\t\t\tif (waitForDisappear ? !found : found) {\n\t\t\t\t\t\t\tclearInterval(checkInterval);\n\t\t\t\t\t\t\tresolve({\n\t\t\t\t\t\t\t\taction: 'wait_for',\n\t\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\t\ttype: waitForDisappear ? 'text_gone' : 'text_appear',\n\t\t\t\t\t\t\t\ttext: targetText\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (Date.now() - startTime > timeout) {\n\t\t\t\t\t\t\tclearInterval(checkInterval);\n\t\t\t\t\t\t\tresolve({\n\t\t\t\t\t\t\t\taction: 'wait_for',\n\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\terror: 'Timeout waiting for text',\n\t\t\t\t\t\t\t\ttype: waitForDisappear ? 'text_gone' : 'text_appear',\n\t\t\t\t\t\t\t\ttext: targetText\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t}, 500);\n\t\t\t\t});\n\t\t\t})();\n\t\t`;return await g(e)},consoleMessages:async t=>({action:"console_messages",success:!0,messages:await a.commands.executeCommand("cursor.browserView.getConsoleLogs")}),networkRequests:async t=>({action:"network_requests",success:!0,requests:await a.commands.executeCommand("cursor.browserView.getNetworkRequests")}),takeScreenshot:async t=>await a.commands.executeCommand("cursor.browserView.takeScreenshot",t),goBack:async t=>await a.commands.executeCommand("cursor.browserView.goBack"),resize:async t=>await a.commands.executeCommand("cursor.browserView.resize",t)}},756:(t,e)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.generateBrowserUIScript=function(t){return`\n(function() {\n\t// Prevent double injection\n\tif (window.__cursorBrowserAutomationInjected) {\n\t\treturn;\n\t}\n\n\t// Only inject in top-level frame\n\tif (window !== window.top) {\n\t\treturn;\n\t}\n\n\twindow.__cursorBrowserAutomationInjected = true;\n\n\tconst tabId = ${JSON.stringify(t)};\n\n\t// =============================================================================\n\t// Element Selection System\n\t// =============================================================================\n\n\tlet selectionMode = false;\n\tlet cursorStyleOverride = null;\n\tlet selectionCursor = null;\n\tlet overlay = null;\n\tlet overlayLabel = null;\n\tlet dragSelectionBox = null;\n\tlet isDragging = false;\n\tlet dragStartX = null;\n\tlet dragStartY = null;\n\n\t// Store element selection listeners for cleanup\n\tlet elementSelectionListeners = null;\n\n\tfunction createSelectionCursor() {\n\t\tconst svgNS = 'http://www.w3.org/2000/svg';\n\t\tconst cursor = document.createElementNS(svgNS, 'svg');\n\t\tcursor.setAttribute('width', '16');\n\t\tcursor.setAttribute('height', '16');\n\t\tcursor.setAttribute('viewBox', '0 0 16 16');\n\t\tcursor.setAttribute('fill', 'none');\n\t\tcursor.setAttribute('data-cursor-overlay', 'true');\n\t\tcursor.setAttribute('aria-hidden', 'true');\n\t\tcursor.setAttribute('focusable', 'false');\n\t\tcursor.style.position = 'fixed';\n\t\tcursor.style.pointerEvents = 'none';\n\t\tcursor.style.zIndex = '2147483646';\n\t\tcursor.style.transform = 'translate(-50%, -50%)';\n\t\tcursor.style.left = '-1000px';\n\t\tcursor.style.top = '-1000px';\n\n\t\tconst title = document.createElementNS(svgNS, 'title');\n\t\ttitle.textContent = 'Cursor overlay';\n\t\tcursor.appendChild(title);\n\n\t\tconst gClip = document.createElementNS(svgNS, 'g');\n\t\tgClip.setAttribute('clip-path', 'url(#clip0_4213_106761)');\n\n\t\tconst gFilter = document.createElementNS(svgNS, 'g');\n\t\tgFilter.setAttribute('filter', 'url(#filter0_d_4213_106761)');\n\n\t\tconst path = document.createElementNS(svgNS, 'path');\n\t\tpath.setAttribute('d', 'M1.68066 2.14282C1.5253 1.49746 2.16954 0.975576 2.75195 1.21118L2.86816 1.26782L3.11035 1.41333L12.958 7.27954L13.2031 7.42505C13.8128 7.78856 13.682 8.70779 12.9951 8.88696L12.7197 8.95825L8.28223 10.1155L6.16895 13.9592L6.02148 14.2288C5.66933 14.869 4.71301 14.741 4.54199 14.0305L4.4707 13.7317L1.74707 2.41724L1.68066 2.14282Z');\n\t\tpath.setAttribute('fill', 'black');\n\t\tpath.setAttribute('stroke', 'white');\n\n\t\tgFilter.appendChild(path);\n\t\tgClip.appendChild(gFilter);\n\n\t\tconst defs = document.createElementNS(svgNS, 'defs');\n\t\tconst filter = document.createElementNS(svgNS, 'filter');\n\t\tfilter.setAttribute('id', 'filter0_d_4213_106761');\n\t\tfilter.setAttribute('x', '-1.51042');\n\t\tfilter.setAttribute('y', '-1.34839');\n\t\tfilter.setAttribute('width', '18.2708');\n\t\tfilter.setAttribute('height', '19.8255');\n\t\tfilter.setAttribute('filterUnits', 'userSpaceOnUse');\n\t\tfilter.setAttribute('color-interpolation-filters', 'sRGB');\n\n\t\tconst feFlood = document.createElementNS(svgNS, 'feFlood');\n\t\tfeFlood.setAttribute('flood-opacity', '0');\n\t\tfeFlood.setAttribute('result', 'BackgroundImageFix');\n\t\tfilter.appendChild(feFlood);\n\n\t\tconst feColorMatrix1 = document.createElementNS(svgNS, 'feColorMatrix');\n\t\tfeColorMatrix1.setAttribute('in', 'SourceAlpha');\n\t\tfeColorMatrix1.setAttribute('type', 'matrix');\n\t\tfeColorMatrix1.setAttribute('values', '0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0');\n\t\tfeColorMatrix1.setAttribute('result', 'hardAlpha');\n\t\tfilter.appendChild(feColorMatrix1);\n\n\t\tconst feOffset = document.createElementNS(svgNS, 'feOffset');\n\t\tfeOffset.setAttribute('dy', '0.666667');\n\t\tfilter.appendChild(feOffset);\n\n\t\tconst feGaussianBlur = document.createElementNS(svgNS, 'feGaussianBlur');\n\t\tfeGaussianBlur.setAttribute('stdDeviation', '1.33333');\n\t\tfilter.appendChild(feGaussianBlur);\n\n\t\tconst feComposite = document.createElementNS(svgNS, 'feComposite');\n\t\tfeComposite.setAttribute('in2', 'hardAlpha');\n\t\tfeComposite.setAttribute('operator', 'out');\n\t\tfilter.appendChild(feComposite);\n\n\t\tconst feColorMatrix2 = document.createElementNS(svgNS, 'feColorMatrix');\n\t\tfeColorMatrix2.setAttribute('type', 'matrix');\n\t\tfeColorMatrix2.setAttribute('values', '0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.5 0');\n\t\tfilter.appendChild(feColorMatrix2);\n\n\t\tconst feBlend1 = document.createElementNS(svgNS, 'feBlend');\n\t\tfeBlend1.setAttribute('mode', 'normal');\n\t\tfeBlend1.setAttribute('in2', 'BackgroundImageFix');\n\t\tfeBlend1.setAttribute('result', 'effect1_dropShadow_4213_106761');\n\t\tfilter.appendChild(feBlend1);\n\n\t\tconst feBlend2 = document.createElementNS(svgNS, 'feBlend');\n\t\tfeBlend2.setAttribute('mode', 'normal');\n\t\tfeBlend2.setAttribute('in', 'SourceGraphic');\n\t\tfeBlend2.setAttribute('in2', 'effect1_dropShadow_4213_106761');\n\t\tfeBlend2.setAttribute('result', 'shape');\n\t\tfilter.appendChild(feBlend2);\n\n\t\tdefs.appendChild(filter);\n\n\t\tconst clipPath = document.createElementNS(svgNS, 'clipPath');\n\t\tclipPath.setAttribute('id', 'clip0_4213_106761');\n\t\tconst rect = document.createElementNS(svgNS, 'rect');\n\t\trect.setAttribute('width', '16');\n\t\trect.setAttribute('height', '16');\n\t\trect.setAttribute('fill', 'white');\n\t\tclipPath.appendChild(rect);\n\t\tdefs.appendChild(clipPath);\n\n\t\tcursor.appendChild(gClip);\n\t\tcursor.appendChild(defs);\n\n\t\treturn cursor;\n\t}\n\n\tfunction showToast(message) {\n\t\ttry {\n\t\t\tconst toast = document.createElement('div');\n\t\t\ttoast.textContent = message;\n\t\t\ttoast.style.position = 'fixed';\n\t\t\ttoast.style.bottom = '16px';\n\t\t\ttoast.style.right = '16px';\n\t\t\ttoast.style.background = 'rgba(0, 0, 0, 0.85)';\n\t\t\ttoast.style.color = 'rgba(255, 255, 255, 0.95)';\n\t\t\ttoast.style.padding = '6px 10px';\n\t\t\ttoast.style.borderRadius = '3px';\n\t\t\ttoast.style.fontSize = '12px';\n\t\t\ttoast.style.fontFamily = 'system-ui, -apple-system, sans-serif';\n\t\t\ttoast.style.fontWeight = '400';\n\t\t\ttoast.style.zIndex = '2147483647';\n\t\t\ttoast.style.pointerEvents = 'none';\n\t\t\ttoast.style.opacity = '0';\n\t\t\ttoast.style.transition = 'opacity 150ms ease';\n\n\t\t\tdocument.body.appendChild(toast);\n\n\t\t\trequestAnimationFrame(() => {\n\t\t\t\ttoast.style.opacity = '1';\n\t\t\t});\n\n\t\t\tsetTimeout(() => {\n\t\t\t\ttoast.style.opacity = '0';\n\t\t\t\tsetTimeout(() => {\n\t\t\t\t\tif (toast.parentNode) {\n\t\t\t\t\t\ttoast.parentNode.removeChild(toast);\n\t\t\t\t\t}\n\t\t\t\t}, 150);\n\t\t\t}, 2000);\n\t\t} catch (e) {\n\t\t\t// Silently fail\n\t\t}\n\t}\n\n\tfunction enableElementSelection() {\n\t\tif (elementSelectionListeners) {\n\t\t\treturn;\n\t\t}\n\n\t\tselectionMode = true;\n\t\tdocument.body.style.cursor = 'none';\n\n\t\tif (!cursorStyleOverride) {\n\t\t\tcursorStyleOverride = document.createElement('style');\n\t\t\tcursorStyleOverride.textContent = '* { cursor: none !important; }';\n\t\t\tdocument.head.appendChild(cursorStyleOverride);\n\t\t}\n\n\t\tif (!selectionCursor) {\n\t\t\tselectionCursor = createSelectionCursor();\n\t\t\tdocument.body.appendChild(selectionCursor);\n\t\t}\n\n\t\tif (!overlay) {\n\t\t\toverlay = document.createElement('div');\n\t\t\toverlay.style.cssText = 'position:fixed;background:rgba(58,150,221,0.3);border:2px solid #3a96dd;pointer-events:none;z-index:2147483647;transition:all 0.1s ease;';\n\t\t\tdocument.body.appendChild(overlay);\n\n\t\t\toverlayLabel = document.createElement('div');\n\t\t\toverlayLabel.style.cssText = 'position:fixed;background:#3a96dd;color:white;padding:2px 6px;font-size:11px;font-family:system-ui,-apple-system,sans-serif;font-weight:500;border-radius:2px;pointer-events:none;z-index:2147483648;transition:all 0.1s ease;white-space:nowrap;';\n\t\t\tdocument.body.appendChild(overlayLabel);\n\t\t}\n\n\t\tconst mousedownListener = (e) => {\n\t\t\tif (!selectionMode) return;\n\t\t\te.preventDefault();\n\t\t\te.stopPropagation();\n\n\t\t\tisDragging = true;\n\t\t\tdragStartX = e.clientX;\n\t\t\tdragStartY = e.clientY;\n\n\t\t\tif (overlay) {\n\t\t\t\toverlay.style.display = 'none';\n\t\t\t}\n\t\t\tif (overlayLabel) {\n\t\t\t\toverlayLabel.style.display = 'none';\n\t\t\t}\n\n\t\t\tif (!dragSelectionBox) {\n\t\t\t\tdragSelectionBox = document.createElement('div');\n\t\t\t\tdragSelectionBox.style.cssText = 'position:fixed;background:rgba(58,150,221,0.1);border:2px dashed #3a96dd;pointer-events:none;z-index:2147483647;';\n\t\t\t\tdocument.body.appendChild(dragSelectionBox);\n\t\t\t}\n\t\t\tdragSelectionBox.style.left = dragStartX + 'px';\n\t\t\tdragSelectionBox.style.top = dragStartY + 'px';\n\t\t\tdragSelectionBox.style.width = '0px';\n\t\t\tdragSelectionBox.style.height = '0px';\n\t\t};\n\n\t\tconst mousemoveListener = (e) => {\n\t\t\tif (!selectionMode) return;\n\n\t\t\tif (selectionCursor) {\n\t\t\t\tselectionCursor.style.left = e.clientX + 'px';\n\t\t\t\tselectionCursor.style.top = e.clientY + 'px';\n\t\t\t}\n\n\t\t\tif (isDragging && dragSelectionBox) {\n\t\t\t\tconst currentX = e.clientX;\n\t\t\t\tconst currentY = e.clientY;\n\n\t\t\t\tconst left = Math.min(dragStartX, currentX);\n\t\t\t\tconst top = Math.min(dragStartY, currentY);\n\t\t\t\tconst width = Math.abs(currentX - dragStartX);\n\t\t\t\tconst height = Math.abs(currentY - dragStartY);\n\n\t\t\t\tdragSelectionBox.style.left = left + 'px';\n\t\t\t\tdragSelectionBox.style.top = top + 'px';\n\t\t\t\tdragSelectionBox.style.width = width + 'px';\n\t\t\t\tdragSelectionBox.style.height = height + 'px';\n\t\t\t} else if (!isDragging && overlay && overlayLabel) {\n\t\t\t\tconst element = document.elementFromPoint(e.clientX, e.clientY);\n\t\t\t\tif (element && element !== overlay && element !== overlayLabel && element !== selectionCursor && element !== dragSelectionBox) {\n\t\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\t\toverlay.style.display = '';\n\t\t\t\t\toverlay.style.left = rect.left + 'px';\n\t\t\t\t\toverlay.style.top = rect.top + 'px';\n\t\t\t\t\toverlay.style.width = rect.width + 'px';\n\t\t\t\t\toverlay.style.height = rect.height + 'px';\n\n\t\t\t\t\tconst tagName = element.tagName.toUpperCase();\n\t\t\t\t\toverlayLabel.style.display = '';\n\t\t\t\t\toverlayLabel.textContent = tagName;\n\n\t\t\t\t\tconst labelTop = rect.top > 20 ? rect.top - 20 : rect.top + 2;\n\t\t\t\t\toverlayLabel.style.left = rect.left + 'px';\n\t\t\t\t\toverlayLabel.style.top = labelTop + 'px';\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tconst mouseupListener = (e) => {\n\t\t\tif (!selectionMode) return;\n\t\t\te.preventDefault();\n\t\t\te.stopPropagation();\n\n\t\t\tif (isDragging) {\n\t\t\t\tconst currentX = e.clientX;\n\t\t\t\tconst currentY = e.clientY;\n\n\t\t\t\tconst left = Math.min(dragStartX, currentX);\n\t\t\t\tconst top = Math.min(dragStartY, currentY);\n\t\t\t\tconst width = Math.abs(currentX - dragStartX);\n\t\t\t\tconst height = Math.abs(currentY - dragStartY);\n\n\t\t\t\tif (width > 5 || height > 5) {\n\t\t\t\t\tconst bounds = {\n\t\t\t\t\t\tx: Math.round(left),\n\t\t\t\t\t\ty: Math.round(top),\n\t\t\t\t\t\twidth: Math.round(width),\n\t\t\t\t\t\theight: Math.round(height)\n\t\t\t\t\t};\n\n\t\t\t\t\tif (dragSelectionBox) {\n\t\t\t\t\t\tdragSelectionBox.remove();\n\t\t\t\t\t\tdragSelectionBox = null;\n\t\t\t\t\t}\n\n\t\t\t\t\tdisableElementSelection();\n\n\t\t\t\t\trequestAnimationFrame(() => {\n\t\t\t\t\t\trequestAnimationFrame(() => {\n\t\t\t\t\t\t\tif (window.cursorBrowser) {\n\t\t\t\t\t\t\t\twindow.cursorBrowser.send('area-screenshot-selected', {\n\t\t\t\t\t\t\t\t\tbounds: bounds\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tenableElementSelection();\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\tif (dragSelectionBox) {\n\t\t\t\t\t\tdragSelectionBox.remove();\n\t\t\t\t\t\tdragSelectionBox = null;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tisDragging = false;\n\t\t\t}\n\t\t};\n\n\t\tconst clickListener = (e) => {\n\t\t\tif (!selectionMode) return;\n\t\t\te.preventDefault();\n\t\t\te.stopPropagation();\n\n\t\t\tconst element = e.target;\n\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\tconst computedStyle = window.getComputedStyle(element);\n\n\t\t\tconst path = [];\n\t\t\tlet el = element;\n\t\t\twhile (el && el !== document.body) {\n\t\t\t\tlet selector = el.tagName.toLowerCase();\n\t\t\t\tif (el.id) {\n\t\t\t\t\tselector += '#' + el.id;\n\t\t\t\t} else if (el.className) {\n\t\t\t\t\tselector += '.' + el.className.split(' ').join('.');\n\t\t\t\t}\n\t\t\t\tpath.unshift(selector);\n\t\t\t\tel = el.parentElement;\n\t\t\t}\n\n\t\t\tconst tagName = element.tagName.toLowerCase();\n\t\t\tconst elementDesc = element.id ? \`<\${tagName}#\${element.id}>\` : \`<\${tagName}>\`;\n\t\t\tshowToast(\`Element \${elementDesc} added to chat\`);\n\n\t\t\tif (window.cursorBrowser) {\n\t\t\t\twindow.cursorBrowser.send('element-selected', {\n\t\t\t\t\ttagName: element.tagName,\n\t\t\t\t\tid: element.id,\n\t\t\t\t\tclassName: element.className,\n\t\t\t\t\tinnerText: element.innerText ? element.innerText.substring(0, 200) : '',\n\t\t\t\t\tinnerHTML: element.innerHTML ? element.innerHTML.substring(0, 200) : '',\n\t\t\t\t\tpath: path.join(' > '),\n\t\t\t\t\tattributes: Array.from(element.attributes || []).map(a => ({\n\t\t\t\t\t\tname: a.name,\n\t\t\t\t\t\tvalue: a.value\n\t\t\t\t\t})),\n\t\t\t\t\trect: {\n\t\t\t\t\t\ttop: rect.top,\n\t\t\t\t\t\tleft: rect.left,\n\t\t\t\t\t\twidth: rect.width,\n\t\t\t\t\t\theight: rect.height\n\t\t\t\t\t},\n\t\t\t\t\tstyles: {\n\t\t\t\t\t\tcolor: computedStyle.color,\n\t\t\t\t\t\tbackgroundColor: computedStyle.backgroundColor,\n\t\t\t\t\t\tfontSize: computedStyle.fontSize,\n\t\t\t\t\t\tfontFamily: computedStyle.fontFamily,\n\t\t\t\t\t\tdisplay: computedStyle.display,\n\t\t\t\t\t\tposition: computedStyle.position\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\twindow.cursorBrowser.send('element-selection-complete', {});\n\t\t\t}\n\n\t\t\tdisableElementSelection();\n\t\t};\n\n\t\tdocument.addEventListener('mousedown', mousedownListener, true);\n\t\tdocument.addEventListener('mousemove', mousemoveListener);\n\t\tdocument.addEventListener('mouseup', mouseupListener, true);\n\t\tdocument.addEventListener('click', clickListener, true);\n\n\t\telementSelectionListeners = {\n\t\t\tmousedown: mousedownListener,\n\t\t\tmousemove: mousemoveListener,\n\t\t\tmouseup: mouseupListener,\n\t\t\tclick: clickListener\n\t\t};\n\t}\n\n\tfunction disableElementSelection() {\n\t\tselectionMode = false;\n\t\tdocument.body.style.cursor = '';\n\n\t\tif (cursorStyleOverride) {\n\t\t\tcursorStyleOverride.remove();\n\t\t\tcursorStyleOverride = null;\n\t\t}\n\t\tif (selectionCursor) {\n\t\t\tselectionCursor.remove();\n\t\t\tselectionCursor = null;\n\t\t}\n\t\tif (overlay) {\n\t\t\toverlay.remove();\n\t\t\toverlay = null;\n\t\t}\n\t\tif (overlayLabel) {\n\t\t\toverlayLabel.remove();\n\t\t\toverlayLabel = null;\n\t\t}\n\t\tif (dragSelectionBox) {\n\t\t\tdragSelectionBox.remove();\n\t\t\tdragSelectionBox = null;\n\t\t}\n\n\t\tif (elementSelectionListeners) {\n\t\t\tconst { mousedown, mousemove, mouseup, click } = elementSelectionListeners;\n\t\t\tdocument.removeEventListener('mousedown', mousedown, true);\n\t\t\tdocument.removeEventListener('mousemove', mousemove);\n\t\t\tdocument.removeEventListener('mouseup', mouseup, true);\n\t\t\tdocument.removeEventListener('click', click, true);\n\t\t\telementSelectionListeners = null;\n\t\t}\n\n\t\tisDragging = false;\n\t\tdragStartX = null;\n\t\tdragStartY = null;\n\t}\n\n\twindow.addEventListener('message', (e) => {\n\t\tif (e.data.type === 'enable-element-selection') {\n\t\t\tenableElementSelection();\n\t\t} else if (e.data.type === 'disable-element-selection') {\n\t\t\tdisableElementSelection();\n\t\t}\n\t});\n\n\tdocument.addEventListener('keydown', (e) => {\n\t\tif (e.key === 'Escape' && selectionMode) {\n\t\t\te.preventDefault();\n\t\t\te.stopPropagation();\n\t\t\twindow.postMessage({ type: 'disable-element-selection' }, '*');\n\t\t\treturn;\n\t\t}\n\n\t\tconst isMac = navigator.platform.toUpperCase().indexOf('MAC') >= 0;\n\t\tconst cmdOrCtrl = isMac ? e.metaKey : e.ctrlKey;\n\n\t\tif (cmdOrCtrl && !e.altKey) {\n\t\t\tif (e.key === 'a' && !e.shiftKey) {\n\t\t\t\te.preventDefault();\n\t\t\t\te.stopPropagation();\n\n\t\t\t\tconst target = e.target;\n\t\t\t\tif (target instanceof HTMLInputElement || target instanceof HTMLTextAreaElement) {\n\t\t\t\t\ttarget.select();\n\t\t\t\t} else if (target instanceof HTMLElement && target.isContentEditable) {\n\t\t\t\t\tconst selection = window.getSelection();\n\t\t\t\t\tconst range = document.createRange();\n\t\t\t\t\trange.selectNodeContents(target);\n\t\t\t\t\tselection?.removeAllRanges();\n\t\t\t\t\tselection?.addRange(range);\n\t\t\t\t} else {\n\t\t\t\t\tdocument.execCommand('selectAll');\n\t\t\t\t}\n\t\t\t\treturn;\n\t\t\t}\n\t\t}\n\t}, true);\n\n})();\n`}},857:t=>{t.exports=require("os")},928:t=>{t.exports=require("path")},943:t=>{t.exports=require("fs/promises")}},e={},n=function n(r){var o=e[r];if(void 0!==o)return o.exports;var s=e[r]={exports:{}};return t[r].call(s.exports,s,s.exports,n),s.exports}(256),r=exports;for(var o in n)r[o]=n[o];n.__esModule&&Object.defineProperty(r,"__esModule",{value:!0})})();
//# sourceMappingURL=http://go/sourcemap/sourcemaps/25412918da7e74b2686b25d62da1f01cfcd27680/extensions/cursor-browser-automation/dist/extension.js.map