"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeScan = void 0;
const Observable_js_1 = require("../Observable.js");
const mergeInternals_js_1 = require("./mergeInternals.js");
function mergeScan(accumulator, seed, concurrent = Infinity) {
    return (source) => new Observable_js_1.Observable((subscriber) => {
        let state = seed;
        return (0, mergeInternals_js_1.mergeInternals)(source, subscriber, (value, index) => accumulator(state, value, index), concurrent, (value) => {
            state = value;
        }, false, undefined, () => (state = null));
    });
}
exports.mergeScan = mergeScan;//# sourceMappingURL=http://go/sourcemap/sourcemaps/21a2ed198584d56a91c0b996d1a09c93f8538440/node_modules/rxjs/dist/cjs/internal/operators/mergeScan.js.map