"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.takeWhile = void 0;
const Observable_js_1 = require("../Observable.js");
function takeWhile(predicate, inclusive = false) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let index = 0;
        const operatorSubscriber = (0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                if (predicate(value, index++)) {
                    destination.next(value);
                }
                else {
                    operatorSubscriber.unsubscribe();
                    if (inclusive) {
                        destination.next(value);
                    }
                    destination.complete();
                }
            },
        });
        source.subscribe(operatorSubscriber);
    });
}
exports.takeWhile = takeWhile;//# sourceMappingURL=http://go/sourcemap/sourcemaps/21a2ed198584d56a91c0b996d1a09c93f8538440/node_modules/rxjs/dist/cjs/internal/operators/takeWhile.js.map