/* global crypto */
import { from } from './hasher.js';
function sha(name) {
    return async (data) => new Uint8Array(await crypto.subtle.digest(name, data));
}
export const sha256 = from({
    name: 'sha2-256',
    code: 0x12,
    encode: sha('SHA-256')
});
export const sha512 = from({
    name: 'sha2-512',
    code: 0x13,
    encode: sha('SHA-512')
});//# sourceMappingURL=http://go/sourcemap/sourcemaps/2125c48207a2a9aa55bce3d0af552912c84175d0/node_modules/multiformats/dist/src/hashes/sha2-browser.js.map