import { defineIntegration } from '@sentry/core';
import { startSession, endSessionOnExit } from '../sessions.js';

/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = defineIntegration((options = {}) => {
    return {
        name: 'MainProcessSession',
        setup() {
            startSession(!!options.sendOnCreate);
            endSessionOnExit();
        },
    };
});

export { mainProcessSessionIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/2125c48207a2a9aa55bce3d0af552912c84175d0/node_modules/@sentry/electron/esm/main/integrations/main-process-session.js.map
