"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.last = void 0;
const Observable_js_1 = require("../Observable.js");
const EmptyError_js_1 = require("../util/EmptyError.js");
function last(predicate, defaultValue) {
    const hasDefaultValue = arguments.length >= 2;
    return (source) => new Observable_js_1.Observable((destination) => {
        let index = 0;
        let found = false;
        let lastValue;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next(value) {
                if (!predicate || predicate(value, index++, source)) {
                    found = true;
                    lastValue = value;
                }
            },
            complete() {
                if (found) {
                    destination.next(lastValue);
                    destination.complete();
                }
                else if (hasDefaultValue) {
                    destination.next(defaultValue);
                    destination.complete();
                }
                else {
                    destination.error(new EmptyError_js_1.EmptyError());
                }
            },
        }));
    });
}
exports.last = last;//# sourceMappingURL=http://go/sourcemap/sourcemaps/20b273813c619c9577ec75e3ea9f22723977ed60/node_modules/rxjs/dist/cjs/internal/operators/last.js.map