import { defineIntegration, normalize } from '@sentry/core';
import { addScopeListener } from '../../common/scope.js';
import { getIPC } from '../ipc.js';

/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = defineIntegration(() => {
    return {
        name: 'ScopeToMain',
        setup(client) {
            const ipc = getIPC(client);
            addScopeListener((merged, changed) => {
                ipc.sendScope(JSON.stringify(normalize(merged, 20, 2000)));
                changed.clearBreadcrumbs();
                changed.clearAttachments();
            });
        },
    };
});

export { scopeToMainIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/20b273813c619c9577ec75e3ea9f22723977ed60/node_modules/@sentry/electron/esm/renderer/integrations/scope-to-main.js.map
