Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const carrier = require('./carrier.js');
const scope = require('./scope.js');

/** Get the default current scope. */
function getDefaultCurrentScope() {
  return carrier.getGlobalSingleton('defaultCurrentScope', () => new scope.Scope());
}

/** Get the default isolation scope. */
function getDefaultIsolationScope() {
  return carrier.getGlobalSingleton('defaultIsolationScope', () => new scope.Scope());
}

exports.getDefaultCurrentScope = getDefaultCurrentScope;
exports.getDefaultIsolationScope = getDefaultIsolationScope;//# sourceMappingURL=http://go/sourcemap/sourcemaps/20b273813c619c9577ec75e3ea9f22723977ed60/node_modules/@sentry/core/build/cjs/defaultScopes.js.map
