import { operate } from '../Observable.js';
export function scanInternals(accumulator, seed, hasSeed, emitOnNext, emitBeforeComplete, source, destination) {
    let hasState = hasSeed;
    let state = seed;
    let index = 0;
    source.subscribe(operate({
        destination,
        next: (value) => {
            const i = index++;
            state = hasState
                ?
                    accumulator(state, value, i)
                :
                    ((hasState = true), value);
            emitOnNext && destination.next(state);
        },
        complete: emitBeforeComplete
            ? () => {
                hasState && destination.next(state);
                destination.complete();
            }
            : undefined,
    }));
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/20b273813c619c9577ec75e3ea9f22723977ed60/node_modules/rxjs/dist/esm/internal/operators/scanInternals.js.map