import { defineIntegration } from '@sentry/core';
import { startSession, endSessionOnExit } from '../sessions.js';

/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = defineIntegration((options = {}) => {
    return {
        name: 'MainProcessSession',
        setup() {
            startSession(!!options.sendOnCreate);
            endSessionOnExit();
        },
    };
});

export { mainProcessSessionIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/1910e1fc4fa41b809793f6c5477108b775c0a120/node_modules/@sentry/electron/esm/main/integrations/main-process-session.js.map
