let cachedDebuggerEnabled;

/**
 * Was the debugger enabled when this function was first called?
 */
async function isDebuggerEnabled() {
  if (cachedDebuggerEnabled === undefined) {
    try {
      // Node can be built without inspector support
      const inspector = await import('node:inspector');
      cachedDebuggerEnabled = !!inspector.url();
    } catch {
      cachedDebuggerEnabled = false;
    }
  }

  return cachedDebuggerEnabled;
}

export { isDebuggerEnabled };//# sourceMappingURL=http://go/sourcemap/sourcemaps/177150a443c9e04c8a3fd7f09c535ee4e2a9a3a0/node_modules/@sentry/node-core/build/esm/utils/debug.js.map
