const core = require('@sentry/core');
const electronNet = require('./electron-net.js');
const offlineStore = require('./offline-store.js');

/**
 * Creates a Transport that uses Electrons net module to send events to Sentry. When they fail to send they are
 * persisted to disk and sent later
 */
function makeElectronOfflineTransport(baseTransport = electronNet.makeElectronTransport) {
    return (userOptions) => {
        // `makeElectronOfflineTransport` is a combination of two transports.
        //
        // The base Electron transport (`makeElectronTransport`) is wrapped by `makeOfflineTransport` which stores events to
        // disk when they fail to send.
        return core.makeOfflineTransport(baseTransport)({
            flushAtStartup: true,
            createStore: offlineStore.createOfflineStore,
            ...userOptions,
        });
    };
}

exports.makeElectronOfflineTransport = makeElectronOfflineTransport;//# sourceMappingURL=http://go/sourcemap/sourcemaps/177150a443c9e04c8a3fd7f09c535ee4e2a9a3a0/node_modules/@sentry/electron/main/transports/electron-offline-net.js.map
