/** Ways to communicate between the renderer and main process  */
exports.IPCMode = void 0;
(function (IPCMode) {
    /** Configures Electron IPC to receive messages from renderers */
    IPCMode[IPCMode["Classic"] = 1] = "Classic";
    /** Configures Electron protocol module to receive messages from renderers */
    IPCMode[IPCMode["Protocol"] = 2] = "Protocol";
    /**
     * Configures both methods for best compatibility.
     *
     * Renderers favour IPC but fall back to protocol if IPC has not
     * been configured in a preload script
     */
    IPCMode[IPCMode["Both"] = 3] = "Both";
})(exports.IPCMode || (exports.IPCMode = {}));
const PROTOCOL_SCHEME = 'sentry-ipc';
exports.IPCChannel = void 0;
(function (IPCChannel) {
    /** IPC to check main process is listening */
    IPCChannel["RENDERER_START"] = "sentry-electron.renderer-start";
    /** IPC to pass scope changes to main process. */
    IPCChannel["SCOPE"] = "sentry-electron.scope";
    /** IPC to pass envelopes to the main process. */
    IPCChannel["ENVELOPE"] = "sentry-electron.envelope";
    /** IPC to pass renderer status updates */
    IPCChannel["STATUS"] = "sentry-electron.status";
    /** IPC to pass structured log messages */
    IPCChannel["STRUCTURED_LOG"] = "sentry-electron.structured-log";
})(exports.IPCChannel || (exports.IPCChannel = {}));
const RENDERER_ID_HEADER = 'sentry-electron-renderer-id';
const UTILITY_PROCESS_MAGIC_MESSAGE_KEY = '__sentry_message_port_message__';
/** Does the message look like the magic message */
function isMagicMessage(msg) {
    return !!(msg && typeof msg === 'object' && UTILITY_PROCESS_MAGIC_MESSAGE_KEY in msg);
}
/** Get the magic message to send to the utility process */
function getMagicMessage() {
    return { [UTILITY_PROCESS_MAGIC_MESSAGE_KEY]: true };
}

exports.PROTOCOL_SCHEME = PROTOCOL_SCHEME;
exports.RENDERER_ID_HEADER = RENDERER_ID_HEADER;
exports.getMagicMessage = getMagicMessage;
exports.isMagicMessage = isMagicMessage;//# sourceMappingURL=http://go/sourcemap/sourcemaps/177150a443c9e04c8a3fd7f09c535ee4e2a9a3a0/node_modules/@sentry/electron/common/ipc.js.map
