"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.skipUntil = void 0;
const Observable_js_1 = require("../Observable.js");
const noop_js_1 = require("../util/noop.js");
function skipUntil(notifier) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let taking = false;
        const skipSubscriber = (0, Observable_js_1.operate)({
            destination,
            next: () => {
                skipSubscriber?.unsubscribe();
                taking = true;
            },
            complete: noop_js_1.noop,
        });
        (0, Observable_js_1.from)(notifier).subscribe(skipSubscriber);
        source.subscribe((0, Observable_js_1.operate)({ destination, next: (value) => taking && destination.next(value) }));
    });
}
exports.skipUntil = skipUntil;//# sourceMappingURL=http://go/sourcemap/sourcemaps/1685afce45886aa5579025ac7e077fc3d4369c50/node_modules/rxjs/dist/cjs/internal/operators/skipUntil.js.map