"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.repeat = void 0;
const Observable_js_1 = require("../Observable.js");
const empty_js_1 = require("../observable/empty.js");
const timer_js_1 = require("../observable/timer.js");
function repeat(countOrConfig) {
    let count = Infinity;
    let delay;
    if (countOrConfig != null) {
        if (typeof countOrConfig === 'object') {
            ({ count = Infinity, delay } = countOrConfig);
        }
        else {
            count = countOrConfig;
        }
    }
    return count <= 0
        ? () => empty_js_1.EMPTY
        : (source) => new Observable_js_1.Observable((destination) => {
            let soFar = 0;
            let sourceSub;
            const resubscribe = () => {
                sourceSub?.unsubscribe();
                sourceSub = null;
                if (delay != null) {
                    const notifier = typeof delay === 'number' ? (0, timer_js_1.timer)(delay) : (0, Observable_js_1.from)(delay(soFar));
                    const notifierSubscriber = (0, Observable_js_1.operate)({
                        destination,
                        next: () => {
                            notifierSubscriber.unsubscribe();
                            subscribeToSource();
                        },
                    });
                    notifier.subscribe(notifierSubscriber);
                }
                else {
                    subscribeToSource();
                }
            };
            const subscribeToSource = () => {
                let syncUnsub = false;
                sourceSub = source.subscribe((0, Observable_js_1.operate)({
                    destination,
                    complete: () => {
                        if (++soFar < count) {
                            if (sourceSub) {
                                resubscribe();
                            }
                            else {
                                syncUnsub = true;
                            }
                        }
                        else {
                            destination.complete();
                        }
                    },
                }));
                if (syncUnsub) {
                    resubscribe();
                }
            };
            subscribeToSource();
        });
}
exports.repeat = repeat;//# sourceMappingURL=http://go/sourcemap/sourcemaps/1685afce45886aa5579025ac7e077fc3d4369c50/node_modules/rxjs/dist/cjs/internal/operators/repeat.js.map