"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.SDK_INFO = void 0;
const version_1 = require("../../version");
const semantic_conventions_1 = require("@opentelemetry/semantic-conventions");
/** Constants describing the SDK in use */
exports.SDK_INFO = {
    [semantic_conventions_1.SEMRESATTRS_TELEMETRY_SDK_NAME]: 'opentelemetry',
    [semantic_conventions_1.SEMRESATTRS_PROCESS_RUNTIME_NAME]: 'browser',
    [semantic_conventions_1.SEMRESATTRS_TELEMETRY_SDK_LANGUAGE]: semantic_conventions_1.TELEMETRYSDKLANGUAGEVALUES_WEBJS,
    [semantic_conventions_1.SEMRESATTRS_TELEMETRY_SDK_VERSION]: version_1.VERSION,
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/0fca4e35e4ec970eed0348ed65d1d59d26234260/node_modules/@opentelemetry/core/build/src/platform/browser/sdk-info.js.map