import { context } from '@opentelemetry/api';
import { getScopesFromContext } from '@sentry/opentelemetry';

/**
 * Update the active isolation scope.
 * Should be used with caution!
 */
function setIsolationScope(isolationScope) {
  const scopes = getScopesFromContext(context.active());
  if (scopes) {
    scopes.isolationScope = isolationScope;
  }
}

export { setIsolationScope };//# sourceMappingURL=http://go/sourcemap/sourcemaps/0aab11a4598c8cf51c251d5df1cf581ee65f9d20/node_modules/@sentry/node-core/build/esm/sdk/scope.js.map
